setfreq m8

' update (lower, usually) this as functions are added to the AI

symbol FREETIME = 200 ' time between end of calcs and start of gps grab. how deterministic is this exactly? note we are in verbose mode.
symbol GPS_IN = 2 ' input pin for gps
symbol PROG_IN = pin1 ' input pin for programming waypoint
symbol SERVO_OUT = 1 ' output to servo controller




setint $02, $02
' so we can probably shave off quite a bit of it if we remove human-readable strings
' and delegate a 08 to do that.

'===============================================================================
'-------------------- uM-FPU V2.0 PICAXE definitions ---------------------------
' no need to be scared here, we're not even using 90% of these
' they must be in the code anyway though until we are sure we're not
'===============================================================================

symbol	fpuID		= 0xC8	' uM-FPU I2C address
'-------------------- uM-FPU opcodes -------------------------------------------
symbol	SELECTA	= 0x00	' select A register
symbol	SELECTB	= 0x10	' select B register
symbol	FWRITEA	= 0x20	' write to register and select A
symbol	FWRITEB	= 0x30	' write to register and select B
symbol	FREAD		= 0x40	' read from register
symbol	FSET		= 0x50	' A = REG
symbol	LSET		= 0x50	' A = REG
symbol	FADD		= 0x60	' A = A + REG (float)
symbol	FSUB		= 0x70	' A = A - REG (float)
symbol	FMUL		= 0x80	' A = A * REG (float)
symbol	FDIV		= 0x90	' A = A / REG (float)
symbol	LADD		= 0xA0	' A = A + REG (long)
symbol	LSUB		= 0xB0	' A = A - REG (long)
symbol	LMUL		= 0xC0	' A = A * REG (long)
symbol	LDIV		= 0xD0	' A = A / REG (long)
symbol	SQRT		= 0xE0	' A = sqrt(A)	
symbol	LOG		= 0xE1	' A = ln(A)
symbol	LOG10		= 0xE2	' A = log(A)
symbol	EXP		= 0xE3	' A = e ** A
symbol	EXP10		= 0xE4	' A = 10 ** A
symbol	SIN		= 0xE5	' A = sin(A) radians
symbol	COS		= 0xE6	' A = cos(A) radians
symbol	TAN		= 0xE7	' A = tan(A) radians
symbol	FLOOR		= 0xE8	' A = nearest integer <= A
symbol	CEIL		= 0xE9	' A = nearest integer >= A
symbol	ROUND		= 0xEA	' A = nearest integer to A
symbol	NEGATE	= 0xEB	' A = -A
symbol	ABS		= 0xEC	' A = |A|
symbol	INVERSE	= 0xED	' A = 1 / A
symbol	DEGREES	= 0xEE	' A = A / (PI / 180) radians to degrees
symbol	RADIANS	= 0xEF	' A = A * (PI / 180) degreees to radians
symbol	SYNC		= 0xF0	' synchronization
symbol	FLOAT		= 0xF1	' copy A to register 0 and convert to float
symbol	FIX		= 0xF2	' copy A to register 0 and convert to long
symbol	FCOMPARE	= 0xF3	' compare A and B
symbol	LOADBYTE	= 0xF4	' write signed byte to reg 0, convert to float
symbol	LOADUBYTE	= 0xF5	' write unsigned byte to reg 0, convert to float
symbol	LOADWORD	= 0xF6	' write signed word to reg 0, convert to float
symbol	LOADUWORD	= 0xF7	' write unsigned word to reg 0, convert to float
symbol	READSTR	= 0xF8	' read zero terminated string
symbol	ATOF		= 0xF9	' convert ASCII to float, store in A register
symbol	FTOA		= 0xFA	' convert float to ASCII
symbol	ATOL		= 0xFB	' convert ASCII to long, store in A register
symbol	LTOA		= 0xFC	' convert long to ASCII
symbol	FSTATUS	= 0xFD	' get the status of A register
symbol	XOP		= 0xFE	' extended opcode
symbol	NOP		= 0xFF	' nop
symbol	FUNCTION	= 0x00	' (XOP) user functions 0-15
symbol	READBYTE	= 0x90      ' (XOP) read low 8 bits of A (long)
symbol	READWORD	= 0x91      ' (XOP) read low 16 bits of A (long)
symbol	READLONG	= 0x92      ' (XOP) read 32-bit long value from A
symbol	READFLOAT	= 0x93      ' (XOP) read floating point value from A
symbol	LINCA		= 0x94      ' (XOP) A = A + 1 (long)
symbol	LINCB		= 0x95      ' (XOP) A = A + 1 (long)
symbol	LDECA		= 0x96      ' (XOP) A = A - 1 (long)
symbol	LDECB		= 0x97      ' (XOP) A = A - 1 (long)
symbol	LAND		= 0x98      ' (XOP) A = A AND B (long)
symbol	LOR		= 0x99      ' (XOP) A = A OR B (long)
symbol	LXOR		= 0x9A      ' (XOP) A = A XOR B (long)
symbol	LNOT		= 0x9B      ' (XOP) A = NOT A (long)
symbol	LTST		= 0x9C      ' (XOP) status of A AND B (long)
symbol	LSHIFT	= 0x9D      ' (XOP) shift A by B bits (long)
symbol	LWRITEA	= 0xA0	' (XOP) write long to register and select A
symbol	LWRITEB	= 0xB0	' (XOP) write long to register and select B
symbol	LREAD		= 0xC0	' (XOP) read long from register
symbol	LUDIV		= 0xD0	' (XOP) A = A / REG (unsigned long)
symbol	POWER		= 0xE0	' (XOP) A = A ** B
symbol	ROOT		= 0xE1	' (XOP) A = the Bth root of A
symbol	FMIN		= 0xE2	' (XOP) A = minimum of A and B
symbol	FMAX		= 0xE3	' (XOP) A = maximum of A and B
symbol	FRACTION	= 0xE4	' (XOP) load reg 0 with the fractional part of A
symbol	ASIN		= 0xE5	' (XOP) A = asin(A) radians
symbol	ACOS		= 0xE6	' (XOP) A = acos(A) radians
symbol	ATAN		= 0xE7	' (XOP) A = atan(A) radians
symbol	ATAN2		= 0xE8	' (XOP) A = atan(A/B)
symbol	LCOMPARE	= 0xE9	' (XOP) long compare A and B
symbol	LUCOMPARE	= 0xEA	' (XOP) unsigned long compare A and B
symbol	LSTATUS	= 0xEB	' (XOP) long status
symbol	LNEGATE	= 0xEC	' (XOP) A = -A (long)
symbol	LABS		= 0xED	' (XOP) A = |A| (long)
symbol	LEFT		= 0xEE	' (XOP) right parenthesis
symbol	RIGHT		= 0xEF	' (XOP) left parenthesis
symbol	LOADZERO	= 0xF0	' (XOP) load register 0 with zero
symbol	LOADONE	= 0xF1	' (XOP) load register 0 with 1.0
symbol	LOADE		= 0xF2	' (XOP) load register 0 with e
symbol	LOADPI	= 0xF3	' (XOP) load register 0 with pi
symbol	LONGBYTE	= 0xF4	' (XOP) write signed byte to reg 0, convert to long
symbol	LONGUBYTE	= 0xF5	' (XOP) write unsigned byte to reg 0, convert to long
symbol	LONGWORD	= 0xF6	' (XOP) write signed word to reg 0, convert to long
symbol	LONGUWORD	= 0xF7	' (XOP) write unsigned word to reg 0, convert to long
symbol	IEEEMODE	= 0xF8	' (XOP) set IEEE mode (default)
symbol	PICMODE	= 0xF9	' (XOP) set PIC mode
symbol	CHECKSUM	= 0xFA	' (XOP) calculate code checksum
symbol	BREAK		= 0xFB	' (XOP) debug breakpoint
symbol	TRACEOFF	= 0xFC	' (XOP) turn debug trace off
symbol	TRACEON	= 0xFD	' (XOP) turn debug trace on
symbol	TRACESTR	= 0xFE	' (XOP) send debug string to trace buffer
symbol	VERSION	= 0xFF	' (XOP) get version string
symbol	syncChar	= 0x5C      ' sync character 

'-------------------- uM-FPU variables -----------------------------------------
symbol	dataWord	= w6		' (b13,b12) data word
symbol	dataHigh	= b13		' high byte of dataWord
symbol	dataLow	= b12		' low byte of dataWord
symbol	dataByte	= b12		' (alternate name)
symbol	opcode	= b13		' opcode (same as dataHigh)
symbol	opcode2	= b12		' opcode2 (same as dataLow)
symbol	reg		= b13		' register value (same as dataHigh)
symbol	format	= b12		' format (same as dataLow)
symbol	fpu_status	= b12		' status byte (same as dataLow)
'-------------------- uM-FPU status bits ---------------------------------------
symbol	IS_ZERO	= 0x81	' positive zero
symbol	IS_NZERO	= 0x83	' negative zero
symbol	IS_NEGATIVE	= 0x82	' negative
symbol	IS_NAN	= 0x84	' NaN (Not-a-Number)
symbol	IS_PINF	= 0x88	' positive infinity
symbol	IS_NINF	= 0x8A	' negative infinity
' everything is done thru custom functions so these
' aren't actually THAT needed.... still write them down somewhere
symbol TEMP              = 0            ' uM-FPU register 0
symbol XA                = 1            ' uM-FPU register 1
symbol XAD               = 2            ' uM-FPU register 2
symbol YA                = 3            ' uM-FPU register 3
symbol YAD               = 4            ' uM-FPU register 4
symbol XB                = 5            ' uM-FPU register 5
symbol XBD               = 6            ' uM-FPU register 6
symbol YB                = 7            ' uM-FPU register 7
symbol YBD               = 8            ' uM-FPU register 8
symbol VELX              = 5            ' uM-FPU register 12
symbol VELY              = 7            ' uM-FPU register 13
symbol XX                = 10           ' uM-FPU register 10
symbol YY                = 11           ' uM-FPU register 11
symbol SOUT              = 12           ' uM-FPU register 12
symbol HOUT              = 13           ' uM-FPU register 13
symbol DOUT              = 14           ' uM-FPU register 14
symbol TOUT              = 15           ' uM-FPU register 15

'-------------------- uM-FPU V2 Function Definitions --------------------------
symbol FunctionSpeedAndHeading   = FUNCTION+0            ' uM-FPU user function 0
symbol FunctionDistanceAndTracking  = FUNCTION+1         ' uM-FPU user function 1
symbol FunctionCoordsToLong  = FUNCTION+2                ' uM-FPU user function 2
'symbol FunctionHeightAndTimeToDistance = FUNCTION+3      ' uM-FPU user function 3

'-------------------- Picaxe Variable Definitions ---------------------------
symbol Sped = W2                        ' signed word variable 
symbol Head = W3                        ' signed word variable 
symbol Trak = W4                        ' signed word variable 
symbol Dist = W5                        ' signed word variable 
symbol TurnLeft = W1  ' for turning algorithm (X axis may be backwards)
symbol TurnRight = W0 ' for turning algorithm (X axis may be backwards)



' -------------------- Picaxe Memory Definitions ---------------------------
' note that $50 to $7D is TAKEN by the gps string, rest is available for waypoints etc.
' 7E and 7F store the bearing to deal with zero-speed case (special)
symbol NSCoord = $54 ' offset for simple gps format
symbol EWCoord = $5C ' offset for simple gps format
symbol EWVel   = $6F ' offset for simple gps format
symbol NSVel   = $74 ' offset for simple gps format


symbol NAV_0 = 0 'c0 c7
symbol NAV_1 = 1 'c8 cf
symbol NAV_2 = 2 'd0 d7
symbol NAV_3 = 3 'd8 df
symbol NAV_4 = 4 'e0 e7
' e8 - ef are used for other stuff, such as keeping track of AI variables.

' these are tentative
' ef - waypoint number we are trying to get to (see nav table above)
symbol NAVMEM = $EF
' ee - 
' ed - 
' ec - 
' eb - 
' ea - 
' e9 -
' e8 -


poke $ef, NAV_0 ' nav point

' actual code starts here
sertxd ("Init",13,10)
gosub fpu_reset ' global FPU init function, keep it simple. must be called at beginning

'servo RUD_OUT, 200


' waypoints are stored as long pairs, EW then SE, total 8 bytes per.

sertxd ("Resetting navpoints",13,10)
''pause 2000

gosub gpsgrab

gosub gpsecho

' if we're doing coord-snatch, execute NOW
WaypSign:
 b12 = NSCoord
 gosub NSEWconvert
 b12 = EWCoord
 gosub NSEWconvert


' storewaypoint2 looks into the gpsgrab-ed string and saves a waypoint
' storewaypoint assumes that b7~b0 contain a signed long

' initialize all waypoints since we can spend the time to do so
b11 = NAV_0
gosub storewaypoint2
b11 = NAV_1
gosub storewaypoint2
b11 = NAV_2
gosub storewaypoint2
b11 = NAV_3
gosub storewaypoint2
b11 = NAV_4
gosub storewaypoint2
peek NAVMEM, b11

sertxd("Navpoint numbers: ",#b7," ",#b6," ",#b5," ",#b4," ",#b3," ",#b2," ",#b1," ",#b0,13,10)



gosub sendwaypoint ' this gets called only when we are actually
                   ' chainging waypoints. this allows routes
                   ' use getwaypointfromFPU to "make" a waypoint from coords
'end ' temp

sertxd ("Navpoints reset",13,10)

'servo RUD_OUT,300
sertxd("Navigating in 3",13,10)
''pause 2000
sertxd("Navigating in 2",13,10)
''pause 2000
sertxd("Navigating in 1",13,10)
''pause 2000
sertxd("Navigating",13,10)

loop:



'''' temporary for telemetry
symbol WindSide = b0
symbol WindDir = b1
symbol WindRec = b2
symbol RangeA = b3
symbol RangeB = b4
symbol VelA = b5
symbol VelB = b6
symbol ServoVar = w6
serin 6, N2400, ("$"),#WindDir,WindSide,WindRec
serin 7, N2400, ("$"),#RangeA,#RangeB,#VelA,#VelB
sertxd("W:",#WindDir,WindSide," - P:",#RangeA,"/",#RangeB,", C:",#VelA,"/",#VelB,13,10) '" - Sail: ")
'''' temporary for telemetry










readadc 0, b11
b11 = b11 / 52 ' 0 to 4
poke NAVMEM, b11



gosub gpsgrab
sertxd("Nav:",#b11,"/4",13,10)


if PROG_IN = 0 then CoordSign

addwaypoint:
 b12 = NSCoord
 gosub NSEWconvert
 b12 = EWCoord
 gosub NSEWconvert
' peek NAVMEM, b11
 gosub storewaypoint2
 sertxd ("Nav ",#b11," stored",13,10)



CoordSign:
 b12 = NSCoord
 gosub NSEWconvert
 b12 = EWCoord
 gosub NSEWconvert

peek NAVMEM, b11
' test: see if this works before adding waypoint database

gosub sendwaypoint ' this gets called only when we are actually
                   ' chainging waypoints. this allows routes
                   ' use getwaypointfromFPU to "make" a waypoint fr



DoDistanceTracking:
 gosub sendcoordstoFPU
 writei2c 0, (XOP, FunctionDistanceAndTracking )


' convert NSEW for velocity here while the FPU calculates. yay multiprocessing!
VelSign:
 b12 = EWVel
 gosub NSEWconvert
 b12 = NSVel
 gosub NSEWconvert

DoSpeedHeading:
 gosub sendvel
 gosub fpu_wait
 writei2c 0, (XOP, FunctionSpeedAndHeading )


'--- Sped = SOUT
	writei2c 0, (SOUT)
	gosub fpu_wait
	writei2c 0, (XOP, READWORD)
	readi2c 0, (B5, B4)


' restore last heading just in case
peek $7E,b6
peek $7F,b7
' if I'm not moving, I can't get a valid heading so skip it, keep the last one
if Sped < 1 then skiphead
'--- Head = HOUT
	writei2c 0, (HOUT)
	gosub fpu_wait
	writei2c 0, (XOP, READWORD)
	readi2c 0, (B7, B6)
' preserve heading accordingly
poke $7E,b6
poke $7F,b7

skiphead:
'--- Dist = DOUT 
	writei2c 0, (DOUT)
	gosub fpu_wait
	writei2c 0, (XOP, READWORD)
	readi2c 0, (B11, B10)

'--- Trak = TOUT
	writei2c 0, (TOUT)
	gosub fpu_wait
	writei2c 0, (XOP, READWORD)
	readi2c 0, (B9, B8)


'gosub gpsecho


'peek $50,b0
'peek $51,b1
peek $52,b2
peek $53,b3

if trak < 3600 then oktrak
sertxd("FPU ERROR!",13,10)

oktrak:
sertxd("Time: ",b2,b3," - Dist: ",#Dist," - Track: ",#Trak," - Speed: ",#Sped," - Head: ",#Head,13,10)

TurnLeft = 3600 + Head - Trak % 3600
TurnRight = 3600 - Head + Trak % 3600

if TurnLeft > TurnRight then tright
if TurnLeft < TurnRight then tleft
if TurnLeft = 1800 or TurnRight = 1800 then treverse
'servo RUD_OUT, 300
sertxd("Keep going straight",13,10)
''pause FREETIME
''pause FREETIME

''pause 1
goto loop

treverse:
'servo RUD_OUT, 200
sertxd("Turn around",13,10)
''pause FREETIME
''pause FREETIME

''pause 1
goto loop

tleft:
sertxd("Turn left ",#TurnLeft)
''pause FREETIME
''pause FREETIME


''pause 1
goto loop

tright:
sertxd("Turn right ",#TurnRight)
TurnRight = TurnRight / 18
TurnRight = 300 - TurnRight
'servo RUD_OUT, TurnRight
sertxd(" - 'servo    ",#TurnRight,13,10)
''pause FREETIME
''pause FREETIME

''pause 1
goto loop


' heap o' subroutines here

' after gpsgrab, send coordinates to FPU for conversion

'symbol EWVel   = $6F ' offset for simple gps format
'symbol NSVel   = $74 ' offset for simple gps format

sendvel:
 sendNSVel:
  peek $74,b0
  peek $75,b1
  peek $76,b2
  peek $77,b3
  peek $78,b4
  writei2c 0, (ATOL, b0,b1,b2,b3,b4,$00,VELY,LSET)
 sendEWVel:
  peek $6F,b0
  peek $70,b1
  peek $71,b2
  peek $72,b3
  peek $73,b4
  writei2c 0, (ATOL, b0,b1,b2,b3,b4,$00,VELX,LSET)
return

sendcoordstoFPU:
 sendNSDegrees:
  peek $54, b0
  peek $55, b1
  peek $56, b2
  writei2c 0, (ATOL, b0,b1,b2,$00,YAD,LSET)
 sendNSMinutes: ' keep b0 for sign
  peek $57, b1 
  peek $58, b2
  peek $59, b3
  peek $5A, b4
  peek $5B, b5
  writei2c 0, (ATOL, b0,b1,b2,b3,b4,b5,$00,YA,LSET)
 sendEWDegrees:
  peek $5C, b0
  peek $5D, b1
  peek $5E, b2
  peek $5F, b3
  writei2c 0, (ATOL, b0,b1,b2,b3,$00,XAD,LSET)
 sendEWMinutes: ' keep b0 for sign
  peek $60, b1
  peek $61, b2
  peek $62, b3
  peek $63, b4
  peek $64, b5
  writei2c 0, (ATOL, b0,b1,b2,b3,b4,b5,$00,XA,LSET)
return




'
' consider using function above to store a waypoint somewhere, too!
'

' use this after sendcoordstoFPU to have a long pair for waypoint storage
getwaypointfromFPU:
gosub fpu_wait
symbol LREADX = LREAD + XAD
symbol LREADY = LREAD + YAD
writei2c 0, (XOP, FunctionCoordsToLong )
gosub fpu_wait
writei2c 0, (XOP, LREADX)
readi2c 0, (b3,b2,b1,b0)
gosub fpu_wait
writei2c 0, (XOP, LREADY)
readi2c 0, (b7,b6,b5,b4)
return

' temporary - we will have to decide waypoint format & figure out
' how to store them! (use routine above and save as 2 longs maybe? )
'
'
' in fact, we can just send the waypoint when we first have one to
' send and then leave it there! saves time? worth it?
'
' save coords in "milliminutes" in an ascii string somewhere maybe?
'
' waypoints are stored as signed longs
' b11 has the offset for the waypoint "bank" number, 0=c0, 1=c8 etc.
sendwaypoint:
b11 = b11 * 8 + 7 + $c0
peek b11,b7
b11 = b11 - 1
peek b11,b6
b11 = b11 - 1
peek b11,b5
b11 = b11 - 1
peek b11,b4
b11 = b11 - 1
peek b11,b3
b11 = b11 - 1
peek b11,b2
b11 = b11 - 1
peek b11,b1
b11 = b11 - 1
peek b11,b0
b11 = b11 - $c0 / 8

gosub fpu_wait
symbol LWRITEXBD = LWRITEA + XBD
symbol LWRITEYBD = LWRITEA + YBD
writei2c 0, (XOP, LWRITEXBD, b3, b2, b1, b0) ' may need a XBD before XOP
gosub fpu_wait
writei2c 0, (XOP, LWRITEYBD, b7, b6, b5, b4) ' may need a YBD before XOP
return


' sequentially grabs gps string
gpsgrab:
'setint $00,$00
' sertxd("gr")
 serin GPS_IN, N600, ("@"),b0,b0,b0,b0,b0,b0,b0,b0
 for b0 = $50 to $7D ' E and F preserve last heading
  serin 2, N600, b1
  poke b0, b1
 next b0
' sertxd("ab",13,10)
'setint $02,$02
return

' converts the letters N S E W into zeros or minus signs for use in numerical calcs
' go here in case of fuckupness with serial line
NSEWFailsafe:
sertxd("GPS SIGNAL LOST",13,10)
gosub gpsgrab
' what do we do here? depends a lot on what's going on
' keep the gpsgrab for now
' converts the letters N S E W into zeros or minus signs for use in numerical calcs
NSEWconvert:
 peek b12,b13
 if b13 = "_" then NSEWfailsafe
 if b13 = "S" or b13 = "W" then NSEWminus
  b13 = "+" ' ascii zero, used at 
  poke b12,b13
  return
 NSEWminus:
  b13 = "-"
  poke b12,b13
  return

gpsecho:
 sertxd("@,(-time-)")
 for b0 = $50 to $7D ' E and F preserve last heading
  peek b0,b1
  sertxd(b1)
 next b0
 sertxd(13,10)
return


' b11 has the offset for the waypoint "bank" number, 0=c0, 1=c8 etc.
storewaypoint2:
gosub sendcoordstoFPU
gosub getwaypointfromFPU ' from FPU
' interestingly, this makes for a VERY easy way to have a vehicle follow me
' if i have a gps and a xbee in my pocket.
storewaypoint:
b11 = b11 * 8 + 7 + $c0
poke b11,b7
b11 = b11 - 1
poke b11,b6
b11 = b11 - 1
poke b11,b5
b11 = b11 - 1
poke b11,b4
b11 = b11 - 1
poke b11,b3
b11 = b11 - 1
poke b11,b2
b11 = b11 - 1
poke b11,b1
b11 = b11 - 1
poke b11,b0
b11 = b11 - $c0 / 8
return



'===============================================================================
'-------------------- uM-FPU V2.0 PICAXE support routines ----------------------
'===============================================================================

fpu_reset:
	i2cslave fpuID, i2cfast, i2cbyte
	pause 1			' reset the FPU hardware
fpu_reset_2:
	writei2c 1, (0)			' reset the uM-FPU
	pause 8				' wait for reset to complete
      sertxd("FPU reset",13,10)
	
	writei2c 0, (SYNC)		' check for synchronization
						' (fall through to fpu_readStatus)
	readi2c 0, (fpu_status)		' read status byte
	if fpu_status <> SyncChar then fpu_reset_2
	return

fpu_wait:
	readi2c 0, (fpu_status)		' wait for ready status
	if fpu_status <> 0 then fpu_wait
	return

'==================== end of uM-FPU support routines ===========================


interrupt:

 sertxd ("Interrupt test",13,10)
return




