' servo bank switcher / watchdog
' reads a servo data line, returns decision on output
symbol SERVO_IN  = 1
symbol WHO_GOTIT = 2
symbol MODE_IN   = pin3
symbol DISTRESS  = 4
symbol PULSELEN  = w2
symbol PULSELEN2 = w3
symbol PULSELEN3 = w4
symbol PULSELEN4 = w5
symbol LASTOUT   = bit0

' mode 0 - no dedicated channels
' no pulse: use bank 1 (assume RC is off, use AI)
' pulse less than 1.5 msec: use bank 0 (use RC, RC is on)
' pulse more than 1.5 msec: use bank 0 (use RC, RC is on)

' mode 1 - dedicated channel
' no pulse: use bank 1 (assume RC is off, use AI)
' pulse less than 1.5 msec: use bank 0 (use RC, RC is saying "I got it")
' pulse more than 1.5 msec: use bank 1 (use AI, RC is saying "U got it")
'
' if in mode 1 no pulse is detected, and last time we were in RC mode,
' raise distress pin so the AI knows that there probably was an unintended
' interruption in radio signal
'
' mode 0 has no distress option
'
'
'

' mode pin can force "I got it" for all pulses and just turn on AI for
' no pulse. This is useful if we don't have a separate channel to turn
' the AI on and off (i.e. cheap 2chan radio that is on boat...)
'
'
'
' Sensor string:
' $PD, Mode, Rc/Ai, Radio+/Radio-, Normal/Distress, *CRLF 
'
'
' ex ' $PD,0,R,+,N*

' for testing/debug
' servo 4, 150
' for testing/debug
low DISTRESS
low WHO_GOTIT
low 0
setfreq m8

lastout = 1 'if we do AI takeoff
loop:

sample:
  pulsin SERVO_IN, 1, PULSELEN
'  setfreq m4

result:


  if PULSELEN = 0 then skipdoublecheck

' this is used with cheap AM receivers to check
' for line noise that may generate spurious
' pulses. We check 4 pulses and only return
' control to the RC if all 4 are valid.

' Note that this could be done more efficiently
' with a for loop, the reason why we don't is
' simply that this is marginally faster.

doublecheck:
'  setfreq m8
  pulsin SERVO_IN, 1, PULSELEN
  pulsin SERVO_IN, 1, PULSELEN2
  pulsin SERVO_IN, 1, PULSELEN3
  pulsin SERVO_IN, 1, PULSELEN4
  if PULSELEN  > 410 or PULSELEN < 190 then disc
  if PULSELEN2 > 410 or PULSELEN2 < 190 then disc
  if PULSELEN3 > 410 or PULSELEN3 < 190 then disc
  if PULSELEN4 > 410 or PULSELEN4 < 190 then disc
  pulsin SERVO_IN, 1, PULSELEN
  pulsin SERVO_IN, 1, PULSELEN2
  pulsin SERVO_IN, 1, PULSELEN3
  pulsin SERVO_IN, 1, PULSELEN4
  if PULSELEN  > 410 or PULSELEN < 190 then disc
  if PULSELEN2 > 410 or PULSELEN2 < 190 then disc
  if PULSELEN3 > 410 or PULSELEN3 < 190 then disc
  if PULSELEN4 > 410 or PULSELEN4 < 190 then disc




skipdoublecheck:
'  setfreq m4
  pause 10
'  sertxd("$PD,",#MODE_IN)
  if PULSELEN  > 410 or PULSELEN  < 190 then disc
  if PULSELEN  > 300 and MODE_IN = 1 then lon

  sertxd(",R,+,")
  low WHO_GOTIT
  low 0
  low DISTRESS
  lastout = 0
  goto endloop

lon:
'  sertxd(",A,+,")
  ' for testing/debug
  low DISTRESS
  high WHO_GOTIT
  high 0
  lastout = 1
  goto endloop

disc:
'  sertxd(",A,-,")
  high WHO_GOTIT
  high 0
  if lastout = 0 and MODE_IN = 1 then dodistress

endloop:
'  sertxd("N*",13,10)
goto loop

dodistress:
  ' for testing/debug
  high DISTRESS
  sertxd("D*",13,10)
goto loop







