'pins
symbol SONAR_2 = 1
symbol SONAR_1 = 4
symbol RANGEMAX = 3000'1250

'vars
symbol TEMP    = w0 ' b0 and b1 also do double duty as signers

symbol RANGE1  = w5
symbol RANGE2  = w4

symbol OLD1  = w3
symbol OLD2  = w2

symbol VEL1  = w1
symbol VEL2  = w6

init:
low SONAR_1
low SONAR_2
setfreq m8
OLD1 = RANGEMAX
OLD2 = RANGEMAX
RANGE1 = RANGEMAX
RANGE2 = RANGEMAX

begin:
'goto getsonar2

if OLD1 != 0 then
getsonar1:
  high SONAR_1
  input SONAR_1
  pulsin SONAR_1, 1, TEMP
  if TEMP > RANGEMAX then
	TEMP = RANGEMAX
  endif
  OLD1 = RANGE1
  RANGE1 = TEMP
endif

if OLD2 != 0 then
getsonar2:
  high SONAR_2
  input SONAR_2
  pulsin SONAR_2, 1, TEMP
  if TEMP > RANGEMAX then
	TEMP = RANGEMAX
  endif
  OLD2 = RANGE2
  RANGE2 = TEMP
endif





calculate:
VEL1 = RANGE1 - OLD1
VEL2 = RANGE2 - OLD2


if VEL1 > 32768 then
  b0 = "-"
  VEL1 = 0 - VEL1
else 
  b0 = " "
endif

if VEL2 > 32768 then
  b1 = "-"
  VEL2 = 0 - VEL2
else 
  b1 = " "
endif




sertxd ("$PS,L,",#RANGE1,",R,",#RANGE2,",l,",b0,#VEL1,",r,",b1,#VEL2,"*",13,10)

if RANGE1 < RANGEMAX then
  pause 1
endif

if RANGE2 < RANGEMAX then
  pause 1
endif

goto begin















