'pins
symbol SER_OUT = 0
symbol SONAR_1 = 1
symbol SONAR_2 = 4
symbol ALERT   = 2 ' goes high on proximity alert(s), use for interrupt
'vars
symbol PREV1   = b2
symbol PREV2   = b3
symbol RANGE1  = b4
symbol RANGE2  = b5
symbol VEL1    = b6
symbol VEL2    = b7
symbol TEMP    = w6 ' 12 13

symbol CLOSINGALERT = 140 ' Trigger alert when this close IF we're moving towards obstacle
symbol PROXALERT    = 30  ' Trigger alert when this close, regardless

init:
VEL1 = 50
VEL2 = 50
PREV1 = 127
PREV2 = 127
low SONAR_1
low SONAR_2
low ALERT
setfreq m8



begin:
'goto getsonar2

getsonar1:
high SONAR_1
input SONAR_1
pulsin SONAR_1, 1, TEMP
PREV1 = RANGE1
RANGE1 = TEMP * 22 / 200 max 150 min 1 'was 250, POS sonar sensors ... replace


getsonar2:
high SONAR_2
input SONAR_2
pulsin SONAR_2, 1, TEMP
PREV2 = RANGE2
RANGE2 = TEMP * 22 / 200 max 150 min 1


calculate:
if RANGE1 < 27 and RANGE1 > 22 then echofix1
goto tx1

echofix1:
TEMP = PREV1 * 3 + 150 / 4
RANGE1 = TEMP


tx1:
if RANGE2 < 27 and RANGE2 > 22 then echofix2
goto tx2

echofix2:
TEMP = PREV2 * 3 + 150 / 4
RANGE2 = TEMP

tx2:
VEL2 = 50 + RANGE2 - PREV2 min 1 max 100
VEL1 = 50 + RANGE1 - PREV1 min 1 max 100

sertxd ("$PS,A,",#RANGE1,",B,",#RANGE2,",a,",#VEL1,",b,",#VEL2,"*",13,10)
pause 2
goto begin












