symbol SONAR_1 = 4
symbol ACCEL_Y = 2
symbol ACCEL_X = 3
symbol TEMP_IN = 1

symbol VAR_X  = w5
symbol VAR_Y  = w4
symbol VAR_T  = w3
symbol VAR_S  = w2
symbol sign_X = b3 ' w1
symbol sign_Y = b2 ' w1
symbol TEMP   = w1
symbol SONARFAIL = b0
symbol MAXFAIL = 5
symbol ZEROACC_X = 994 + 19 ' for calibration
symbol ZEROACC_Y = 984 + 17' for calibration
symbol SONAR_MAX = 3000 ' slightly wonky sensor


setfreq m8
SONARFAIL = 0

begin:

VAR_Y = 0
VAR_X = 0
VAR_T = 0
VAR_S = 0
TEMP = 0

getsonar:
if SONARFAIL < MAXFAIL then
  high SONAR_1
  input SONAR_1
  pulsin SONAR_1, 1, TEMP
  VAR_S = VAR_S + TEMP
  if VAR_S = 0 then
     SONARFAIL = SONARFAIL + 1
  else
     SONARFAIL = 0
  endif
endif


getaccel:
  pulsin ACCEL_Y, 1, TEMP
  VAR_Y = VAR_Y + TEMP
  pulsin ACCEL_X, 1, TEMP
  VAR_X = VAR_X + TEMP
  
gettemp: 
if SONARFAIL = MAXFAIL then    ' with check for sonar sensor connect
  high SONAR_1
  low SONAR_1
  input SONAR_1
  readadc10 TEMP_IN, VAR_T
  if pin4 = 1 then
      SONARFAIL = 0
  endif 
  readadc10 TEMP_IN, TEMP
  if pin4 = 1 then
      SONARFAIL = 0
  endif 
else					 ' without check for sonar sensor connect
  readadc10 TEMP_IN, VAR_T
  readadc10 TEMP_IN, TEMP
endif

  VAR_T = VAR_T + TEMP








calculate:

'VAR_X = VAR_X / 9
'VAR_Y = VAR_Y / 9
'VAR_S = VAR_S / 9
'VAR_T = VAR_T / 5


sign_y = " "
if VAR_Y < ZEROACC_Y then
  VAR_Y = ZEROACC_Y - VAR_Y
  sign_y =  "-"
else 
  VAR_Y = VAR_Y - ZEROACC_Y
endif

sign_x = " "
if VAR_X < ZEROACC_X then
  VAR_X = ZEROACC_X - VAR_X
  sign_x =  "-"
else 
  VAR_X = VAR_X - ZEROACC_X
endif

VAR_T = 2048 - VAR_T


if SONARFAIL < MAXFAIL then
  if VAR_S > SONAR_MAX then
    VAR_S = SONAR_MAX
  endif
  sertxd("$PM,X,",sign_x,#VAR_X,",Y,",sign_y,#VAR_Y,",T,",#VAR_T,",s,",#VAR_S,"*",13,10)
  if VAR_S = SONAR_MAX then
    pause 1
  endif
else
  sertxd("$PG,X,",sign_x,#VAR_X,",Y,",sign_y,#VAR_Y,",T,",#VAR_T,"*",13,10)
endif

' the M/G can be used to determine whether the sonar is functioning (or, use s=0? mah?)


goto begin






