''******************************
''* GarminTXT GPS parse+interp *
''*   (C) 2006 Matteo K. Borri *
''******************************                                                                


var     
        long          GPSSA
        long          GPSStack[l#GPSStackSize] 'GPSStack[100)] ' temporary
        long          gpscog ' cog flag/id
        'long          SensorDataAddress ' init to @SensorData
        long          SensorDataAddressLast ' init to @SensorData
        long          SensorDataAddressDelta ' init to @SensorData
        long          InterpRoundAddress

        byte          gpspin
        long          baud
        byte          gpsround


        long          lastbear
        long          lasthead
        long          lastspeed_g
        long          lastspeed_d


        long          gettingnum
        long          interpround
        long          rounds
        long          gpsindex
        long          time
        long          lat_temp
        long          lon_temp
        long          vel_lat
        long          vel_lon
        long          wplatindex
        long          wplonindex
        long          currwp
        long          wplat_float
        long          wplon_float
        long          head
        long          dist
        long          trak

        long          temphead
        long          tempspeed
        long          numrounds
        long          temptime
        long          cosh
        long          sinh
        long          fint
        long          GpsMisses

        
        

        

        

        

obj     
        m         :   "DynamicMathLib"
        timer     : "dyntimerF" ' or dyntimerF if we need it fudge-factored to go a little faster
        GPSSerial : "FullDuplexSerialExt"
        'GPSSerial2: "Simple_Serial_RX"
        l       : "NavAI_Lib" ' small library w/ memory map in it


        stak    : "stack_length_debug" ' remove once we know how big the stack must be



PUB start (GPS_Pin, GPSBaud, WPLatAddr, WPLonAddr, WaypointNumAddr, SensorDataLastAddr, SensorDataDeltaAddr, InterpRoundsAddr, GPSStringAddr) : okay
  stop
                        

  m.start
  'SensorDataAddress := SensorDataAddr
  SensorDataAddressLast := SensorDataLastAddr
  SensorDataAddressDelta := SensorDataDeltaAddr
  GPSSA := GPSStringAddr  '@gpsstring
  InterpRoundAddress := InterpRoundsAddr

  stak.Init(@GPSStack,l#GPSStackSize)
'
  repeat 
     okay := gpscog := cognew(GPSUpdate(GPS_Pin, GPSBaud, WPLatAddr, WPLonAddr, WaypointNumAddr), @GPSStack) + 1
  until okay

PUB stop


  GPSSerial.stop
  m.stop
  
  
  if gpscog
    cogstop(gpscog~ - 1)

                                      
PUB GetStackLength
    return stak.GetLength  
con keeplock = true
    numcommands = 3 ' See main function for this
                              
PRI GPSUpdate (GPS_Pin, GPSBaud, WPLatAddr, WPLonAddr, WaypointNumAddr)' | gettingnum, interpround, gpsindex, time, dist, lat_temp, lon_temp, vel_lat, vel_lon, speed_temp, wplatindex, wplonindex, head, trak, currwp, wplat_float, wplon_float, rounds

  gpspin := GPS_Pin
  baud := ||(GPSBaud)

  bytefill(GPSSA, 0, 64)

  GPSSerial.start(GPSPin, -1, %0011, baud)

  
    ' get lock on gps output
  repeat
       byte[(gettingnum)] := GPSSerial.rx
  until (byte[(gettingnum)] == "@")

  
  gpsindex~
  GpsMisses~
  
  ' use gps

  repeat
      {  
    if keeplock
      gpsindex := GPSSA + 3
      repeat
        byte[(gpsindex)] := GPSSerial.rx
      until ((byte[(gpsindex++)] == $0A) and (byte[(gpsindex - 2)] == $0D))
      gpsindex--
      gpsindex -= GPSSA
      GPSSerial.stop
       }

    repeat
      gpsindex := (gpsindex + 1) // 60
       
    until (byte[(GPSSerial.RXBufferAddress + gpsindex)] == $0A)

    bytemove(GPSSA, GPSSerial.RXBufferAddress, 58)
    'gpsindex := 56
'    GPSSerial.rxflush   
    GPSSerial.stop
      
     {

    else
      gettingnum := GPSSA + 3
      repeat 57
       byte[(gettingnum++)] := GPSSerial.rx
      gpsindex := constant(3 + 56)
      GPSSerial.stop
      }


    gettingnum := GPSSA '~ ' := 0
    repeat 64
      byte[(gettingnum++)] -= $30
      'gettingnum++ ' := gettingnum + 1

    gpsindex -= 56

    GPSSA += gpsindex

    
    
     time := byte[(GPSSA+12)] +byte[(GPSSA+11)]*10 + byte[(GPSSA+10)]*60 + byte[(GPSSA+9)]*600 + byte[(GPSSA+8)]*3600 + byte[(GPSSA+7)]*36000
     lat_temp := (long[constant(l#SensorDataAddress  + l#lat)] // 10) + 10 * (byte[(GPSSA+20)] +byte[(GPSSA+19)]*10 +byte[(GPSSA+18)]*100 +byte[(GPSSA+17)]*1000 +byte[(GPSSA+16)]*10000 +byte[(GPSSA+15)]*60000 +byte[(GPSSA+14)]*600000)
     lon_temp := (long[constant(l#SensorDataAddress  + l#lon)] // 10) + 10 * (byte[(GPSSA+29)] +byte[(GPSSA+28)]*10 +byte[(GPSSA+27)]*100 +byte[(GPSSA+26)]*1000 +byte[(GPSSA+25)]*10000 +byte[(GPSSA+24)]*60000 +byte[(GPSSA+23)]*600000 +byte[(GPSSA+22)]*6000000)

     vel_lon := m.slowfdiv(m.ffloat(byte[(GPSSA+44)] +byte[(GPSSA+43)]*10 +byte[(GPSSA+42)]*100 +byte[(GPSSA+41)]*1000),10.0)
     vel_lat := m.slowfdiv(m.ffloat(byte[(GPSSA+49)] +byte[(GPSSA+48)]*10 +byte[(GPSSA+47)]*100 +byte[(GPSSA+46)]*1000),10.0)

    
     GPSSA -= gpsindex
     gettingnum := GPSSA '~ ' := 0
     repeat 64
       byte[(gettingnum++)] += $30    ' preserve GPS string for beamdown if needed

     wplatindex := WPLatAddr + (long[(WaypointNumAddr)]*4)
     wplonindex := WPLonAddr + (long[(WaypointNumAddr)]*4)

     ' - 1   ' because one has been done by the gps itself


      'gettingnum++ ' := gettingnum + 1

   if byte[(GPSSA+13)] == constant( "_")
     'GPSSerial.start(GPSPin, -1, %0011, baud)

     long[constant(l#SensorDataAddress  + l#gpsstatus)]~
     temphead := InterpolateHeadingWithBearing
     long[constant(l#SensorDataAddress  + l#Heading)] := temphead

     'Interpolate (1, long[(InterpRoundAddress)], long[(InterpRoundAddress)], long[(InterpRoundAddress)]+1, 0, long[(wplatindex)], long[(wplonindex)], 255)

     long[constant(l#SensorDataAddress  + l#lonGPS)] := long[constant(l#SensorDataAddress  + l#lon)]
     long[constant(l#SensorDataAddress  + l#latGPS)] := long[constant(l#SensorDataAddress  + l#lat)]

'      lastbear := long[constant(l#SensorDataAddress  + l#Compass)]
'      lasthead := long[constant(l#SensorDataAddress  + l#Heading)]
      long[constant(l#SensorDataAddress  + l#cur_speed)] := m.fadd(lastspeed_g,((m.fsub(long[constant(l#SensorDataAddress  + l#dif_Speed)], lastspeed_d)))) 

      lastbear := long[constant(l#SensorDataAddress  + l#Compass)]
      lasthead := long[constant(l#SensorDataAddress  + l#Heading)]

      lastspeed_g := long[constant(l#SensorDataAddress  + l#cur_speed)]
      lastspeed_d := long[constant(l#SensorDataAddress  + l#dif_speed)]

      GpsMisses++
     
     
   else 
     GpsMisses~
     long[constant(l#SensorDataAddress  + l#gpsstatus)] := 1.0
     

     if (byte[(GPSSA+13)] == constant( "S"))
        lat_temp *= -1
     if (byte[(GPSSA+21)] == constant( "W"))
        lon_temp *= -1
     if (byte[(GPSSA+45)] == constant( "S"))
        vel_lat := m.fneg(vel_lat)
     if (byte[(GPSSA+40)] == constant( "W"))
        vel_lon := m.fneg(vel_lon)
     timer.markSIF(70_000)
     
     long[constant(l#SensorDataAddress  + l#lonGPS)] := lon_temp
     long[constant(l#SensorDataAddress  + l#latGPS)] := lat_temp





    
      tempspeed := m.fdist(vel_lon, vel_lat)

      head := m.FCoordsToDegs(0.0, 0.0, vel_lon, vel_lat)


      

    ' note that the current waypoint is locked between real gps updates



       m.ICorrectedNavCalculation(lon_temp, lat_temp, long[(wplonindex)], long[(wplatindex)], @dist, @trak)   ' this one here WORKS!!!!!

                 
      long[constant(l#SensorDataAddress  + l#lat_delta)] :=  0.0 'm.fadd(0.0,(m.fmul(m.fmul(vel_lat,2.1739),fint))))      ' my fudge factor was 0.460, 1/0.46 is 2.1739, mul faster than div
      long[constant(l#SensorDataAddress  + l#lon_delta)] :=  0.0 'm.fadd(0.0,(m.fmul(m.fmul(vel_lon,2.1739),fint))))






    if (||(lat_temp - long[constant(l#SensorDataAddress  + l#lat)]) < 32767) ' sanity check
      long[constant(l#SensorDataAddress  + l#lat)] :=  lat_temp
      long[constant(l#SensorDataAddress  + l#lon)] := lon_temp
      long[constant(l#SensorDataAddress  + l#cur_speed)] := tempspeed
'     long[(SpeedAddr)] := speed_temp


{                ' sanity check in case the gps speed measurement craps out 
      if m.fcmpi(tempspeed, 1, l#HeadingTreshhold) and (head <> lasthead)
          long[constant(l#SensorDataAddress  + l#Heading)] :=  head
      ' else leave heading alone and trust the compass or gyro
}


      if m.fcmpi(tempspeed, 1, l#HeadingTreshhold)
        long[constant(l#SensorDataAddress  + l#Heading)] :=  head
      ' else use the last compass reading i guess... once we find one that works >_>

      long[constant(l#SensorDataAddress  + l#Distance)] := dist
      long[constant(l#SensorDataAddress  + l#GPSTracking)] :=  trak


      lastbear := long[constant(l#SensorDataAddress  + l#Compass)]
      lasthead := long[constant(l#SensorDataAddress  + l#Heading)]

      lastspeed_g := long[constant(l#SensorDataAddress  + l#cur_speed)]
      lastspeed_d := long[constant(l#SensorDataAddress  + l#dif_speed)]

'    long[(WaypointNumAddr)] := currwp


    ' updates should be done in a burst. Add lock here?   YES, the time value itself is my lock
'     timer.waitSI(0)      ' without the wait, 41 is usable so 40 is probably safe: set to that


     'UpdateDeltas



       
   long[constant(l#SensorDataAddress  + l#GPSTime)] :=  (time * 100)  'seconds, howmany, startround, endround, baudrate, WPLat, WPLon, gpsactivateround
   long[constant(l#SensorDataAddress  + l#GPSTimeReceive)] := 1.0


   UpdateDeltas
    
    'rounds++

   if (long[(InterpRoundAddress)] > 3) ' if rounds are less than this, do the interpolation here and don't bother
        gpsround := long[(InterpRoundAddress)]*3/4
         ' change this to prevent locking issues
        Interpolate(1, long[(InterpRoundAddress)], 1, long[(InterpRoundAddress)]+1, 0, long[(wplatindex)], long[(wplonindex)], gpsround)
   else
        Interpolate(1, long[(InterpRoundAddress)], 1, long[(InterpRoundAddress)]+1, baud, long[(wplatindex)], long[(wplonindex)], 255)
        GPSSerial.start(gpspin, -1, %0011, baud)


pri InterpolateHeadingWithBearing
return m.fMathTurnAmount((m.fmul(m.fMathAngle(m.FMathTurnAmount(long[constant(l#SensorDataAddress  + l#Compass)], lastbear)),long[constant(l#SensorDataAddress  + l#CompassTrim)])),lasthead)
                                                         
pri Interpolate (seconds, howmany, startround, endround, baudrate, WPLat, WPLon, gpsactivateround) | currentround

  repeat seconds
    currentround := startround
    temptime := (((long[constant(l#SensorDataAddress  + l#GPSTime)] + 51) / 100) * 100)
    long[constant(l#SensorDataAddress  + l#GPSTime)] := temptime
    repeat (endround -  startround) '(howmany)'(endround - startround)
         if (baudrate)
            timer.markSIF((95_000 - (57000000/baudrate)) / (howmany))
         else
            timer.markSIF(95_000 / howmany)
         temptime := DoInterpCalculations(howmany, currentround++, WPLat, WPLon)
         if (currentround == gpsactivateround)
             GPSSerial.start(gpspin, -1, %0011, baud)
         if (howmany < 70)  ' was 30
             timer.waitSIF(0)
         'long[constant(l#SensorDataAddress  + l#GPSTimeReceive)] := 0.0    ' set by the main ai function
         long[constant(l#SensorDataAddress  + l#GPSTime)] := temptime    ' this also triggers the main AI function, so make sure it's updated last!!!!!
         

                                                                                                             
pub DoInterpCalculations(numroundspersec, localround, WPLat, WPLon)

      if (rounds > 30)
         m.lock ' this is the function that does the most heavy lifting math wise, so let's dedicate a cog to it

      cosh := m.FcosD(long[constant(l#SensorDataAddress  + l#Heading)])
      sinh := (m.FsinD(long[constant(l#SensorDataAddress  + l#Heading)]))   ' does this fix the negative-loc thing? must check
      fint := m.fdiv(m.ffloat(localround),m.ffloat(numroundspersec))
      
'      vel_lat := m.slowfmul(long[constant(l#SensorDataAddress  + l#cur_speed)],cosh)
'      vel_lon := m.slowfmul(long[constant(l#SensorDataAddress  + l#cur_speed)],sinh)

    ' cross-interp between differential speed from sensor (accelerometer, PSID, tach) and current GPS speed
      tempspeed := m.fadd(lastspeed_g,((m.fsub(long[constant(l#SensorDataAddress  + l#dif_Speed)], lastspeed_d))))

      {
      vel_lat := m.fmul(long[constant(l#SensorDataAddress  + l#cur_speed)],cosh)
      vel_lon := m.fmul(long[constant(l#SensorDataAddress  + l#cur_speed)],sinh)
      }
      vel_lat := m.fmul(tempspeed,cosh)
      vel_lon := m.fmul(tempspeed,sinh)
      
      temptime := ((long[constant(l#SensorDataAddress  + l#GPSTime)] / 100 * 100) + (100 * localround / numroundspersec))
'      m.ICorrectedNavCalculation(long[constant(l#SensorDataAddress  + l#lon)], long[constant(l#SensorDataAddress  + l#lat)], WPLon, WPLat, @tempdst, @temptrk)   ' this one here WORKS!!!!!

      
      temphead := InterpolateHeadingWithBearing'm.fMathTurnAmount((m.fmul(m.fMathAngle(m.FMathTurnAmount(long[constant(l#SensorDataAddress  + l#Compass)], lastbear)),2.0)),lasthead)
                                              
      long[constant(l#SensorDataAddress  + l#lat_delta)] :=  (m.fmul(m.fdiv(vel_lat,m.LatMeters(m.ffloat(long[constant(l#SensorDataAddress  + l#lat)]))),fint))      ' my fudge factor was 0.460, 1/0.46 is 2.1739, mul faster than div - then for fractional fint, multiplied by 3

      long[constant(l#SensorDataAddress  + l#lon_delta)] :=  (m.fmul(m.fdiv(vel_lon,m.LonMeters(m.ffloat(long[constant(l#SensorDataAddress  + l#lat)]))),fint))      ' at these coords, only the lattiude fudger is good. USE A TABLE DAMIT

'      long[constant(l#SensorDataAddress  + l#lat_delta)] :=  (m.slowfmul(m.fdiv(vel_lat,m.LatMeters(m.ffloat(long[constant(l#SensorDataAddress  + l#lat)]))),fint))      ' my fudge factor was 0.460, 1/0.46 is 2.1739, mul faster than div - then for fractional fint, multiplied by 3
'      long[constant(l#SensorDataAddress  + l#lon_delta)] :=  (m.slowfmul(m.fdiv(vel_lon,m.LonMeters(m.ffloat(long[constant(l#SensorDataAddress  + l#lat)]))),fint))      ' at these coords, only the lattiude fudger is good. USE A TABLE DAMIT

      long[constant(l#SensorDataAddress  + l#lat)] :=  (long[constant(l#SensorDataAddress  + l#latGPS)] + m.fround(long[constant(l#SensorDataAddress  + l#lat_delta)]))
      long[constant(l#SensorDataAddress  + l#lon)] :=  (long[constant(l#SensorDataAddress  + l#lonGPS)] + m.fround(long[constant(l#SensorDataAddress  + l#lon_delta)]))
      
      'm.ICorrectedNavCalculation(long[constant(l#SensorDataAddress  + l#lon)], long[constant(l#SensorDataAddress  + l#lat)], WPLon, WPLat, @tempdst, @temptrk)   ' this one here WORKS!!!!!
      m.ICorrectedNavCalculation(long[constant(l#SensorDataAddress  + l#lon)], long[constant(l#SensorDataAddress  + l#lat)], WPLon, WPLat, @dist, @trak)   ' this one here WORKS!!!!!

      long[constant(l#SensorDataAddress  + l#cur_speed)] := tempspeed
      long[constant(l#SensorDataAddress  + l#Heading)] := temphead
      long[constant(l#SensorDataAddress  + l#Distance)] := dist


      UpdateDeltas   
      


      return temptime

 
pri UpdateDeltas | tempd

      tempd~
      if (rounds > 30)
         m.lock ' this is the function that does the most heavy lifting math wise, so let's dedicate a cog to it
      repeat
        'long[(SensorDataAddressDelta + tempd)] := m.slowfsub(long[(SensorDataAddress + tempd)], long[(SensorDataAddressLast + tempd)])
        if (long[(l#SensorDataAddress + tempd)] <> long[(SensorDataAddressLast + tempd)])
            long[(SensorDataAddressDelta + tempd)] := m.fsub(long[(l#SensorDataAddress + tempd)], long[(SensorDataAddressLast + tempd)]) 
        'else
        '    long[(SensorDataAddressDelta + tempd)]~
        tempd += 4
      until tempd == constant(26*4)
      m.unlock

      longmove(SensorDataAddressLast, l#SensorDataAddress, 26)'constant(l#LastVar/4))