''******************************
''*   NMEA-like sensor parser  *
''*   (C) 2006 Matteo K. Borri *
''* portions by Chrissy Keller *
''******************************                                                                
''
        
var     
        byte          sensorstringtype[5]
        byte          length
        long          SensorStack[((l#SensorStackSize))] ' temporary
        'long          SecondarySensorStack[((l#SensorStackSize))] ' temporary
        long          cog ' cog flag/id
       ' long          cog2
        byte          sensorstring[(40)]
        long          updatecycle
        long          SensorStringAddress
        long          Value1 ' these all have global scope here to reduce number of parameters passed
        long          Value2 ' these all have global scope here to reduce number of parameters passed
        long          Value3 ' these all have global scope here to reduce number of parameters passed
        long          Value4 ' these all have global scope here to reduce number of parameters passed
        long          lowestbatt

        long          FreqS[(5)]
'        long          Freq1
'        long          Freq2
'        long          Freq3
'        long          Freq4
'        long          FreqB
'        long          baudflag  
'        long          baudsp
        long          baud
        byte          RadioPinS
        byte          RadioPinD
        
        long          temp ' redneck serial buffer

        byte          localcnt
        byte          pintemp

        byte          pin[(5)]
        
        'long          SensorDataAddress ' init to @SensorData
        long          SensorTypeAddress ' init to @SensorData

        long          sonartemp1
        long          sonartemp2
        long          sonartemp3

con        SerialGrace = 4000 ' serial port autodetect grace period

           VaneDamageTre = 120.0 ' adjust depending on wind vane magnet
           CompDamageTre = 20.0 ' adjust depending on wind vane magnet
' copy this to anything that uses sensors!
'usage: long[(@SensorData + SensorName)] := whatever        


' Note that the smallest the number, the more often this gets checked. 

' these should really be pre-called by the ai function....


con

           CompassFrequency =   1 ' ideally very urgent
           PSIAFrequency    =   4
           PSIDFrequency    =   4
           SonarFrequency   =   8
           MedleyFrequency  =   8
           WindFrequency    =  16  ' XI with compass anyway, so not that urgent
           BatteryFrequency = 256  ' not at all urgent


obj     serB:   "Simple_Serial_RX"
        m:     "DynamicMathLib"
        fto:     "FtoF" 'for parsing
        l:   "NavAI_Lib"


        stak    : "stack_length_debug" ' remove once we know how big the stack must be



       
        'sertest: "FullDuplexSerialExt"   ' used to see if we have sensors hooked up or not
{
pub pincheck (pinIn, checkfor) | temp

  timeouts~
  if (pinIn <> -1)
     sertest.start(pinIn, -1, baudflag, baudsp)
     repeat
         temp := sertest.rxtime(constant(SerialGrace/50))
         if (temp == -1)
             timeouts+= 25'+ 'pinB := -1  
         else
             timeouts++
     until (timeouts > 250 or temp == checkfor)

     sertest.stop

     if (timeouts > 250)
         return -1
  return pinIn
}

pub pincheck (pinIn, checkfor) | timeouts

  timeouts~
  if (pinIn <> $FF) ' was -1
     serB.start(pinIn, -1, baud)
     repeat
         temp := serB.rxtime(constant(SerialGrace))'/5))
         if (temp == -1)
             timeouts+= 25'+ 'pinB := -1  
         else
             timeouts++
     until (timeouts > 250 or ((temp & $FF)== checkfor))

     serB.stop

     if (timeouts > 250)
         return ((pinIn & $FF) | $80) ' assumes pin 0 isn't being used for this
         
  return (pinIn & $FF)

 
PUB start (SensorPinRD, SensorPinRS, SensorBaud, SensorPinB, SensorPin1, SensorPin2, SensorPin3, SensorPin4, SensorTypeAddr) : okay 
  stop
  'cog2~
  pin[(0)] := SensorPinB' & $FF | $80 ' the | $80 forces autodetect
  pin[(1)] := SensorPin1' & $FF | $80 ' the | $80 forces autodetect
  pin[(2)] := SensorPin2' & $FF | $80 ' the | $80 forces autodetect
  pin[(3)] := SensorPin3' & $FF | $80 ' the | $80 forces autodetect
  pin[(4)] := SensorPin4' & $FF | $80 ' the | $80 forces autodetect

  
  localcnt~
  repeat 
    dira[(pin[(localcnt)])]~
    pin[(localcnt)]   |= $80
  until localcnt++ == 5
  

  RadioPinS := SensorPinRS
  RadioPinD := SensorPinRD

'  SensorDataAddress := SensorDataAddr
  SensorTypeAddress := SensorTypeAddr + 1
' this checks for whether there actually are sensors connected -- ties up a cog.

'  gettingnum:=0
'  repeat 57
'  gpsstring[(gettingnum)]:=0
'  gettingnum:=gettingnum+1

'  baudsp := || SensorBaud
  baud := SensorBaud
'  baudflag := %0000
'  if (SensorBaud < 0)
'     baudflag := %0011

' initialize everything to 128 to make sure it gets run
  longfill(@FreqS[(0)], $00000080, 5)

  stak.Init(@SensorStack,l#SensorStackSize)

  repeat
    okay := cog := cognew(SensorUpdate, @SensorStack) + 1
  until okay


PUB GetStackLength
    return stak.GetLength  
PUB stop

'' Stop GPS driver - frees a cog
  m.stop
  fto.stop
 ' if cog2
 '   cogstop(cog2~ - 1)
  if cog
    cogstop(cog~ - 1)


PRI SensorRead (SensorIndex)    

    
    if (pin[(SensorIndex)] < $80)
    
      if(((long[constant(l#SensorDataAddress  + l#UpdCycle)]) // FreqS[(SensorIndex)]) == 0) '(Frequency(FreqS[(SensorIndex)]))

        serB.start(pin[(SensorIndex)], -1, baud)
        length~ ' := 0
        'temp~

{
        ' neater code but tends to glitch
        repeat
          sensorstring := serB.rxtime(SerialGrace) & $FF
          if sensorstring == "$"
             repeat
                sensorstring[(++length)] := serB.rxtime(SerialGrace) & $FF
             until (sensorstring[(length)] == 10 or sensorstring[(length)] == $FF)
          if sensorstring[(length)] == $FF
             pin[(SensorIndex)] |= $80
             sensorstringtype[(SensorIndex)] := "_"
             FreqS[(SensorIndex)] := 128
             return
        until (sensorstring[(length)] == 10)    
}

        repeat
          temp := serB.rxtime(SerialGrace) 
        until (temp == "$" or temp == -1)

          if (temp == -1)
             pin[(SensorIndex)] |= $80
             sensorstringtype[(SensorIndex)] := "_"
             FreqS[(SensorIndex)] := 128
             return


        repeat
          sensorstring[(++length)] := serB.rxtime(SerialGrace) & $7F
        until (sensorstring[(length)] == 13 or sensorstring[(length)] == $7F)

          if (sensorstring[(length)] == $7F)
             pin[(SensorIndex)] |= $80 ' flag as inconclusive
             sensorstringtype[(SensorIndex)] := "?" ' "_"
             FreqS[(SensorIndex)] := 128
             return
 

        sensorstring[(0)] := temp & $7F   ' do this here so it doesn't mess with the timing during the loop
        sensorstring[(++length)]~


        sensorstringtype[(SensorIndex)] := sensorstring[(2)]
        {
        if (cog2 == 0)
           m.forceslow
           cog2 := (cognew(ReadSensorString(@sensorstring,SensorIndex),@SecondarySensorStack) + 1)
           if (cog2 == 0)
              ReadSensorString(@sensorstring,SensorIndex)
        else
        }
           ReadSensorString(@sensorstring,SensorIndex)
           
        return

      
    else

        
        pintemp := (pin[(SensorIndex)] & $7F) 
        if (ina[(pintemp)])         ' ... but i am getting something on input...
             pin[(SensorIndex)] := pincheck(pintemp, "$")  ' ... see if a sensor has reconnected

    long[constant(l#SensorDataAddress  + l#Radio)] := (ina[(RadioPinS)]*2 + ina[(RadioPinD)])  ' condensed CheckRadioStatus


PRI SensorUpdate ' | radiolet, temp, cursor1, cursor2, SensorType1, SensorType2, SensorType3, SensorType4
    LowestBatt := 65535
    
    long[constant(l#SensorDataAddress  + l#UpdCycle)]~'
    byte[(SensorTypeAddress-1)] := "R"
    bytefill(@sensorstringtype, "_", 5) ' 0-48
    bytefill(@sensorstring, "#", 39) ' 0-48
    sensorstring[(39)]~


    ' new autodetect only checks pins to which something is actually connected -- much faster!
{    
    localcnt~
    repeat
      pin[(localcnt)] |= $80 ':= pincheck(pin[(cc)], "$")
    until ++localcnt == 5
}                                                                                                                                                                                                               
    repeat
      long[constant(l#SensorDataAddress  + l#UpdCycle)] := ++long[constant(l#SensorDataAddress  + l#UpdCycle)] & $000001FF '// 512

      localcnt~
      repeat
        SensorRead(localcnt)
      until ++localcnt == 5
      bytemove(SensorTypeAddress, @SensorStringType, 5)

pub debug
     return (@sensorstring)      

pri ReadSensorString(stringaddr, SensorIndex) | addr', temp, temp2, temp3, temp4, sonartemp1, sonartemp2  

      addr := stringaddr+2

      sonartemp1 := long[constant(l#SensorDataAddress  + l#SonarC)] ' avoid data overlap if we have 3 sonars
      sonartemp2 := long[constant(l#SensorDataAddress  + l#SonarPC)]' avoid data overlap if we have 3 sonars

      case byte[(addr)]


        ' ok for the LAST TIME: B is for battery and C is for compass. This is FINAL.
      
       "B": fto.ParseNextInt(addr, @Value1)
            if (Value1 < LowestBatt and Value1 > 1000)  ' sanity check
              LowestBatt := Value1  ' servos pull battery voltage down, so this gives us a conservative estimate
              long[constant(l#SensorDataAddress  + l#batt_int)] := LowestBatt '(1 + (LowestBatt * 5)+ Value1 ) / 6
              long[constant(l#SensorDataAddress  + l#Battery)] := m.fdiv(m.ffloat(long[constant(l#SensorDataAddress  + l#batt_int)]), long[constant(l#SensorDataAddress  + l#lowbat)])
            FreqS[(SensorIndex)] := BatteryFrequency
            
       "C","c":
          if byte[(addr)] == "C"
            temp := fto.ParseNextInt(addr, @Value1)
            if (addr[(temp+1)] == "L")
               Value1 := Value1 * -1
            m.lock
            temp := m.fdiv(m.ffloat(Value1),10.0)
            long[constant(l#SensorDataAddress  + l#CompassField)] := constant(CompDamageTre + 10.0)
          else
            fto.ParseNextInt(addr, @Value1)
            fto.ParseNextInt(addr, @Value2)
            if (Value1 > 32767)
              Value1 -= 65536
            if (Value2 > 32767)
              Value2 -= 65536
            m.lock
            Value1 := m.ffloat(Value1)
            Value2 := m.ffloat(Value2)
            long[constant(l#SensorDataAddress  + l#CompassField)] := m.FDist(Value1, Value2)
            temp := m.FCoordsToDegs(0,0,(Value1),(Value2))
            temp := m.FMathAngle(temp)
'            temp := m.FMathAngleHysterize(temp, long[constant(l#SensorDataAddress  + l#Compass)], temp, 1.0)
'       long[constant(@SensorData + SDAO + l#_tUrnamount))] := m.FMathAngleHysterize(180.0, long[constant(@SensorData + SDAO + l#_tUrnamount))], turntemp, TurnHysteresis)


               ' if compass has moved, move wind direction also

          if (long[constant(l#SensorDataAddress  + l#WindDir)])     
              addr := long[constant(l#SensorDataAddress  + l#Compass)]
              addr := m.fMathTurnAmount(temp,addr)
              long[constant(l#SensorDataAddress  + l#WindDir)] := m.fMathAngle(m.fadd(long[constant(l#SensorDataAddress  + l#WindDir)], addr)) ' may need turnamount

          if (m.fcmpi(long[constant(l#SensorDataAddress  + l#CompassField)], 1, CompDamageTre))      ' detects wind sensor breakage
             long[constant(l#SensorDataAddress  + l#Compass)] := temp
          m.unlock
          FreqS[(SensorIndex)] := CompassFrequency
            
       "W":
      ' smart wind sensor
            temp := fto.ParseNextInt(addr, @Value1)
            if (stringaddr[(temp+1)] == "L")
               Value1 := Value1 * -1
            long[constant(l#SensorDataAddress  + l#WindDir)] := Value1
            FreqS[(SensorIndex)] := WindFrequency

       "w":
      ' raw wind sensor
            fto.ParseNextInt(addr, @Value1)
            fto.ParseNextInt(addr, @Value2)
            if (Value1 > 32767)
              Value1 := Value1 - 65536
            if (Value2 > 32767)
              Value2 := Value2 - 65536

            Value1 := m.ffloat(Value1)
            Value2 := m.ffloat(Value2)
            m.lock
            temp := (m.FCoordsToDegs(0,0,(Value2),(Value1)))

             
            'temp :=  m.fmod(m.fadd(temp, float(3600 - 1350)),360.0) ' // 3600
            long[constant(l#SensorDataAddress  + l#WindField)] := m.FDist(Value1, Value2)
            if (m.fcmpi(long[constant(l#SensorDataAddress  + l#WindField)], 1, VaneDamageTre))      ' detects wind sensor breakage
                 long[constant(l#SensorDataAddress  + l#WindDir)] := m.fMathAngle(temp)'m.FMathAngle(m.fadd(temp,135.0))
            m.unlock
            FreqS[(SensorIndex)] := WindFrequency

       "S":
' sonar, two transducers. Sonars should be parsed as 1 transducer, 2 transducer and 3 transducers and
' if we have 1tran on a different pin than 2tran, have it happen LATER so we get proper overwrite.            
            fto.ParseNextInt(addr, @Value1)
            fto.ParseNextInt(addr, @Value2)
            fto.ParseNextInt(addr, @Value3)
            fto.ParseNextInt(addr, @Value4)
            
            
            'Value3 := Value3 - 50 ' since the picaxe only outputs positives
            'Value4 := Value4 - 50 ' since the picaxe only outputs positives
            if (Value1 < 2)
                  Value1 := 255              
            if (Value2 < 2)
                  Value2 := 255              
            long[constant(l#SensorDataAddress  + l#SonarL)] := m.fmul(m.ffloat(Value1), 0.01)
            long[constant(l#SensorDataAddress  + l#SonarR)] := m.fmul(m.ffloat(Value2), 0.01)
            long[constant(l#SensorDataAddress  + l#SonarPL)] := m.fmul(m.ffloat(Value3), 0.01)
            long[constant(l#SensorDataAddress  + l#SonarPR)] := m.fmul(m.ffloat(Value4), 0.01)

            length~ ' acts as delimiter for sensorstringtype
            if fto.Contains(@sensorstringtype, "M") == -1
              if fto.Contains(@sensorstringtype, "s") == -1
                sonartemp1 := m.fmul(m.ffloat(((Value1 * 2) + (Value2 * 2) + 2) / 4),0.01)  ' avoid data overlap if we have 3 sonars
                sonartemp2 := m.fmul(m.ffloat(((Value3 * 2) + (Value4 * 2) + 2) / 4),0.01)  ' avoid data overlap if we have 3 sonars

            FreqS[(SensorIndex)] := SonarFrequency

            

' sonar, one transducer. Sonars should be parsed as 1 transducer, 2 transducer and 3 transducers and
' if we have 1tran on a different pin than 2tran, have it happen LATER so we get proper overwrite.            
       "s":
            fto.ParseNextInt(addr, @Value1)
            fto.ParseNextInt(addr, @Value3)
            
            'Value3 := Value3 - 50 ' since the picaxe only outputs positives
            sonartemp1 := m.fmul(m.ffloat(Value1),0.01)           ' avoid data overlap if we have 3 sonars
            sonartemp2 := m.fmul(m.ffloat(Value3),0.01)           ' avoid data overlap if we have 3 sonars'

            FreqS[(SensorIndex)] := SonarFrequency

' "medley" sensor (xaccel-yaccel-temperature-sonar)
' this is a bit of a hack but i wanted to max out a picaxe

       "M": fto.ParseNextInt(addr, @Value1)
            fto.ParseNextInt(addr, @Value2)
            fto.ParseNextInt(addr, @Value3)
            fto.ParseNextInt(addr, @Value4)
            long[constant(l#SensorDataAddress  + l#AccelX)] := m.ffloat(Value1)
            long[constant(l#SensorDataAddress  + l#AccelY)] := m.ffloat(Value2)

            ' needs code for inclination from accels above here
            
            'long[constant(l#SensorDataAddress  + l#Temperature)] := m.ffloat(Value3)
            sonartemp1 := m.fmul(m.ffloat(Value4),0.01)
            sonartemp2 := m.fsub(sonartemp1, sonartemp3) ' temp
            sonartemp3 := sonartemp1
            FreqS[(SensorIndex)] := MedleyFrequency  ' temp
      



            'CK's PSIA sensor*******************************************************************************************
       "a":  'this is d cuz my alt picaxe broke and i don't feel like reprogrmaaing the d one and we are not using d anyway
            fto.ParseNextInt(addr, @Value1)                                                  
            Value1:=m.fdiv(m.fsub((m.ffloat(Value1)),long[(l#SensorDataAddress + l#zero_alt)]),261.54)  'meters up, and 210 feet or about 60 meters is full scale
            'Value1:=m.fdiv(m.fsub((m.ffloat(Value1)),long[(SensorDataAddress +l#zero_alt)]),79.73)  'feet up, and 210 feet or about 60 meters is full scale
            long[constant(l#SensorDataAddress  + l#Alt)] := Value1 'this is commented out for the car test so we can use psia as the drp_dst display variable
            FreqS[(SensorIndex)] := PSIAFrequency

            'CK's PSID sensor*******************************************************************************************
       "d":
            fto.ParseNextInt(addr, @Value1)  '
            Value1:=m.fmul(1.411459,m.fsqr(m.ffloat(Value1)))  'meters per second
            ' this doesn't seem to be saving anything... shouldn't it save into speed? added
            
            ' pick one of these two:
            'long[constant(l#SensorDataAddress  + l#cur_Speed)] := Value1 ' current speed : authoritative, replaces GPS speed entirely

            long[constant(l#SensorDataAddress  + l#dif_Speed)] := Value1 ' differential speed gets cross-interpolated with GPS speed, good if sensor is differentially reliable but not absolutely i.e. PSID

            FreqS[(SensorIndex)] := PSIDFrequency 

       
       other: ' badness happened, reset pin, but check it again soonish


           byte[(addr)]:= "?"
           FreqS[(SensorIndex)] := BatteryFrequency
           'pin[(SensorIndex)] |= $80 
           'SensorFreq := 15
           
' Sonar fix for possible overlap. See above.
      long[constant(l#SensorDataAddress  + l#SonarC)] := (sonartemp1)  ' avoid data overlap if we have 3 sonars
      long[constant(l#SensorDataAddress  + l#SonarPC)] := (sonartemp2) ' avoid data overlap if we have 3 sonars

      byte[(stringaddr)]~  ' marks string as read

   {
  if cog2
    cogstop(cog2~ - 1)
  m.allowfast
   }
'  if cog2
 '   cogstop(cog2~ - 1)

      

{

$PM,X, 29,Y,-1,T,521,s,62*
}
            
            'then average Value1 in the GPS interpolator???, or maybe average and then divide by 1000000 for  more accuracy????




            
            'then average Value1 in the GPS interpolator???, or maybe average and then divide by 1000000 for  more accuracy????

{
pri Frequency(freq)
' this decides how often sensors get checked, out of 100
      return  (((long[constant(l#SensorDataAddress  + l#UpdCycle)]) // freq) == 0)
}
{
pub CheckRadioStatus(SensorPinRs, SensorPinRd) | radiolet, radioval      
' this gets run every once in a while (generally between sensors) to see who has control of the vehicle
      ' save the radio output - maybe do this a bit more often?

      long[constant(l#SensorDataAddress  + l#Radio)] := (ina[(SensorPinRS)]*2+ina[(SensorPinRD)])
      return "R"
       
      {
      radiolet := "#"
      if ((SensorPinRS <> -1) and (SensorPinRD <> -1))    
         'dira[(SensorPinRD)] := 0 ' input
         'dira[(SensorPinRS)] := 0 ' input 
         radioval:= (ina[(SensorPinRS)]*2+ina[(SensorPinRD)]) ' turn to decimal at some point for consistency please
         radiolet := "R"
         long[constant(l#SensorDataAddress  + l#Radio)] := radioval 
      return radiolet      
      }
      
}       
     