con     SensorDataAddress = $00_00_00_A0 ' Memory location for the whole damn thing (see F8)

CON     ' Offsets from sensor data address for sensor values -- saves some ram. See ReadSensorVal and WriteSensorVal below
        'usage: long[@SensorData + SensorName] := whatever
        'usage: whatever := long[@SensorData + SensorName]

        ' Note that this constant block has to be copied to all functions that use it -- sensor parser, GPS parser... and it must be IDENTICAL


        HeadingTreshhold = 1.0
        
        ' let's not waste time with word and byte vars -- use longs for everything and if we use 20 bytes more, who cares...       
        AA      =    0 ' altitude
        BB      =    4 ' float AS A RATIO OF LOW BATTERY!!!! so if low battery is 7.2 and actual battery voltage is 7.5, this is 1.042
        CC      =    8 ' bearing, either from compass sensor or gyro. Is used DIFFERENTIALLY by the interpolator, so x-y orientation isn't a big deal
        DD      =   12 ' distance from waypoint in meters (corrected for spheroid, but Mercator, not great-circle)
        EE      =   16 ' needs to be done, not used right now
        FF      =   20 ' reserved for Chrissy
        GG      =   24 ' Float for g-force? Probably accel in the vertical axis: ask Chrissy
        HH      =   28 ' heading from GPS and/or compass
        II      =   32 ' reserved for Chrissy
        JJ      =   36 ' Servo 1 previous value, useful for delta calcs
        KK      =   40 ' Servo 2 previous value, useful for delta calcs
        LL      =   44 ' Servo 3 previous value, useful for delta calcs
        MM      =   48 ' Servo 4 previous value, useful for delta calcs
        NN      =   52 ' turNamount delta - used to self-calibrate rudder, IF it ever works
        OO      =   56 ' Time since mission start in seconds
        PP      =   60 ' Line-of-sight suggested tracking
        QQ      =   64 ' Force-vectored tracking I think(?)
        RR      =   68 ' Arrival distance in meters
        SS      =   72 ' speed, duh
        TT      =   76 ' not necessarily the GPSTracking, could be vectored tracking; either way, tracking that will be actually used
        UU      =   80 ' see above for derivation
        VV      =   84 ' wind velocity in m/s
        WW      =   88 ' sind direction in m/s
        XX      =   92 ' this variable can be set to reference any of the ones above or below for application-specific use; point to itself for generic scratchpad val
        YY      =   96 ' this variable can be set to reference any of the ones above or below for application-specific use; point to itself for generic scratchpad val
        ZZ      =  100 ' this variable can be set to reference any of the ones above or below for application-specific use; point to itself for generic scratchpad val
        
                
 ' these cannot be accessed directly
      
        CompassField = 104 ' mag field intensity
        WindField = 108 ' reserved for future use

        SonarPR =  112 ' Delta for sonar according to the sensor (as opposed to the prop) 
        SonarPC =  116 ' Delta for sonar according to the sensor (as opposed to the prop)  
        SonarPL =  120 ' Delta for sonar according to the sensor (as opposed to the prop)
        AccelX  =  124 ' Acceleration in the left-right axis
        AccelY  =  128 ' Acceleration in the front-back axis (to stay consistent with 2D maps)
        Radio   =  132 ' Radio control being on or off (might be used for "marginal" servos? do we even need this?)
        UpdCycle=  136 ' Update cycle for sensor parser (IT'S AN INTEGER, WARNING). Used mostly for display and sensor watchdog reset.
        GPSTime =  140 ' UTC time in seconds
        lat      = 144 ' IT'S AN INTEGER, it shouldn't be used in equations anyway. Used by interpolator and occasionally command parser.
        lon      = 148 ' IT'S AN INTEGER, it shouldn't be used in equations anyway. Used by interpolator and occasionally command parser
        cur_wayp = 152  ' int or float? mah?

        CompassTrim = 156 ' heading/tracking trimmer 

        PSIA     = 156  ' is this even used anymore? I think that goes to distance...
        DropDist = 160  ' Should be a generic variable but this is Chrissy's stuff so no touchy 
    GPSTracking =  164 ' Tracking as suggested by the GPS parser  

' this needs to go to a specialized Delta memory table that should mirror the main memtab.... IF we need it, which we shouldn't but hey.

        lat_delta = 168    ' - this should NOT be here at all actually, but it's easier to work with the gps if it is
        lon_delta = 172    ' - this should NOT be here at all actually, but it's easier to work with the gps if it is

        SonarR  =  176 '  Absolute value  
        SonarC  =  180'   Absolute value; generally center sonar is backward-facing if R and L are present 
        SonarL  =  184 '  Absolute value
      GPSUpdRate = 188 ' integer, in 100ths of a second -- used by gps to differentiate TXT, NMEA1 and NMEA2
        batt_int = 192   ' integer in millivolts
        lowbat   = 196   ' integer in millivolts for minimum value
  GPSTimeReceive = 200 ' 1 when we get a gps ping, 0 otherwise  
        
        latGPS   = 204 ' last non-interpolated gps coords
        lonGPS   = 208 ' last non-interpolated gps coords
        trnGPS   = 212 ' last non-interpolated gps turn amount 
    dif_Speed    = 216  ' differential speed for interpolator (use with PSID or tach)
        AccelZ   = 220 ' Acceleration in the front-back axis (to stay consistent with 2D maps)
     gpsStatus   = 224 ' temperature (in nothing specific right now)

       zero_alt  = 228  'this is so ck can zero the alt on the fly! @qz is command - this is Chrissy's stuff so no touchy

       AlphaOffset = 232 ' the letters below are preconfigured in alphabetical order
       CopyOffset = 278 

       Alt     =   232 ' altitude
       Battery =   236 ' float AS A RATIO OF LOW BATTERY!!!! so if low battery is 7.2 and actual battery voltage is 7.5, this is 1.042
       Compass =   240 ' bearing, either from compass sensor or gyro. Is used DIFFERENTIALLY by the interpolator, so x-y orientation isn't a big deal
       Distance =  244 ' distance from waypoint in meters (corrected for spheroid, but Mercator, not great-circle)
       ETA     =   248 ' needs to be done, not used right now
       Fudge   =   252 ' reserved for Chrissy
       Gravity =   256 ' Float for g-force? Probably accel in the vertical axis: ask Chrissy
       Heading =   260 ' heading from GPS and/or compass
ImpatientEquation =264 ' extra equation result goes in here
       OldSer1Val      =   268 ' Servo 1 previous value, useful for delta calcs
       OldSer2Val      =   272 ' Servo 2 previous value, useful for delta calcs
       OldSer3Val      =   276 ' Servo 3 previous value, useful for delta calcs
       OldSer4Val      =   280 ' Servo 4 previous value, useful for delta calcs
       DiffTurnamount      =   284 ' turNamount delta - used to self-calibrate rudder, IF it ever works
       Optime  =   288 ' Time since mission start in seconds
       RawGPSTracking      =   292 ' Line-of-sight suggested tracking
       RawGo2Tracking      =   296 ' Force-vectored tracking I think(?)
       aRRivaldistance   =   300 ' Arrival distance in meters
   cur_Speed   =   304 ' speed, duh
      _Tracking =  308 ' not necessarily the GPSTracking, could be vectored tracking; either way, tracking that will be actually used
     _tUrnamount = 312 ' see above for derivation
   windVel     =   316 ' wind velocity in m/s
       Winddir =   320 ' sind direction in m/s

        
        LastVar =  324 ' END of this series - see above and below. Must be there to tell the compiler how much space to allocate!

        

con  GPSStackSize =    92   ' stacks for spin objects that use them
     SensorStackSize = 72   ' stacks for spin objects that use them
     MainStackSize =   140   ' stacks for spin objects that use them -- should be big, but do we actually need it ? it can vary a lot, consider using end of main mem
     
con '' Sometimes I really need to do bitwise.
{
pub CheckBit(WhereOffset, Which)
    return (byte[@WhereOffset] & (|< Which))

pub SetBit (WhereOffset, Which)
    byte[@WhereOffset] |= (|< Which)

pub ClrBit (WhereOffset, Which)
    byte[@WhereOffset] &= (!(|< Which))
}
pub dummy ' doesn't compile otherwise