'
' NOTE: 
'
' This code is inefficient as hell, if someone wants to give a go at
' optimizing it... well good luck. I'm not a VB programmer and honestly 
' dislike the fact that it puts you in a sandbox, look at all the mess I had
' to do just to do some bitwise operations....
'
' mkb
'

Public Class Form1
    Const CompassRoseCX = 165
    Const CompassRoseCY = 156
    Const CompassRoseRadius = 100.0
    Const CompassRoseRadiusI = 100
    Const TurnHysteresis = 10.0 '5.0 ' these must be IDENTICAL between navcom ai and console!
    Dim WithEvents serialPort As New System.IO.Ports.SerialPort ' IO.Ports.SerialPort
    Dim WithEvents outputPort As New System.IO.Ports.SerialPort ' IO.Ports.SerialPort
    Dim c As Char = " "
    Dim HeadingAngle As Double = -9999
    Dim BearingAngle As Double = -9999
    Dim TrackingAngle As Double = -9999
    Dim Speed As Double = -9999
    Dim Distance As Double = -9999
    Dim WindDir As Double = -9999
    Dim Altitude As Double = -9999
    Dim ExtraVal1 As Double = -9999
    Dim ExtraVal2 As Double = -9999
    Dim ExtraVal3 As Double = -9999
    Dim Waypoint As Integer = -9999
    Dim TurnAmount As Double = -9999
    Dim ByteIndex As Integer = 0
    Dim LatVal As Double = -9999
    Dim LonVal As Double = -9999
    Dim LatValWP As Double = -9999
    Dim LonValWP As Double = -9999
    Dim ServerStarted As Boolean


    Dim GPGGA As New String(c, 80)
    Dim GPRMC As New String(c, 80)
    Dim GPRMB As New String(c, 80)


    Dim Cycles As Long = 0

    Dim httpd As HTTPServer

    Dim InternalMapFile As New System.IO.FileInfo("\") 'CurDir() & "\index.html") ' needs an option to create this file & load it, see mehere






    'Dim vsport As New AxVSPortLib.AxVSPortAx()
    '    Me.AxVSPortAx2 = New AxVSPortLib.AxVSPortAx()


    Dim ParserBusy As Boolean = False
    Dim processString As Boolean = False


    Dim LastLineString As New String(c, 256)
    Dim ComBuffer As New String(c, 256)
    Dim ByteBuffer As Byte()


    Dim crlfstring As String = vbCrLf
    Dim crstring As String = Chr(13)
    Dim lfstring As String = Chr(10)



    Public Sub ServerStop()
        If (ServerStarted) Then
            Try
                httpd.StopServer()
                httpd.cServer.StopServer()
                ZigZagMsg("Server stopped")
                ServerStarted = False
            Catch ex As Exception
                ServerStop()
            End Try
        End If
    End Sub

    Public Sub ServerStart()
        WaitForSerial()
        If (serialPort.IsOpen) Then
            serialPort.DiscardInBuffer()
            serialPort.DiscardOutBuffer()
        End If
        Try
            If ServerStarted = False Then
                httpd.StartServer()
                httpd.cServer.listenerThread.Priority = Threading.ThreadPriority.Lowest
                ZigZagMsg("Server started")
                ServerStarted = True

            End If
        Catch ex As Exception
            ServerStart()
        End Try

    End Sub

    Private Sub Form1_Load( _
       ByVal sender As System.Object, _
       ByVal e As System.EventArgs) _
       Handles MyBase.Load

        Me.Visible = True



        For i As Integer = 0 To _
           My.Computer.Ports.SerialPortNames.Count - 1
            cbbCOMPorts.Items.Add( _
               My.Computer.Ports.SerialPortNames(i))
        Next

        cbbCOMBaud.Text = "38400"
        cbbCOMBaud.Items.Add(1200)
        cbbCOMBaud.Items.Add(2400)
        cbbCOMBaud.Items.Add(4800)
        cbbCOMBaud.Items.Add(9600)
        cbbCOMBaud.Items.Add(19200)
        cbbCOMBaud.Items.Add(38400)
        cbbCOMBaud.Items.Add(57600)
        cbbCOMBaud.Items.Add(115200)


        GPSOutBox.Text = "None"
        GPSOutBox.Items.Add("None")
        GPSOutBox.Items.Add("Internal")
        For i As Integer = 0 To _
           My.Computer.Ports.SerialPortNames.Count - 1
            GPSOutBox.Items.Add( _
               My.Computer.Ports.SerialPortNames(i))
        Next

        LabelAt.SendToBack()

        cbbCOMBaud.Hide()

        ReDim ByteBuffer(512)



        NMEALabel.Font = New Font("Arial", 8.0!, FontStyle.Regular)

        '       HeadingBox.Font = New Font("Arial", 10.0!, FontStyle.Bold)
        '        BearingBox.Font = New Font("Arial", 10.0!, FontStyle.Bold)
        '      txtDataReceived.Font = New Font("Arial", 10.0!, FontStyle.Bold)
        'txtLastLine.Font = New Font("Arial", 10.0!, FontStyle.Bold)
        'lblMessage.Font = New Font("Arial", 10.0!, FontStyle.Bold)

        CompassRoseBox.SendToBack()

        WindBox.Hide()
        WindBox.Enabled = False
        RelWindBox.Hide()
        RelWindBox.Enabled = False
        WindLabel1.Hide()
        WindLabel2.Hide()
        TrackingBox.Hide()
        LonBox.Hide()
        LatBox.Hide()
        TrackingBox.Enabled = False
        AltBar.Hide()
        AltBar.Enabled = True
        DistBar.Hide()
        DistBar.Enabled = False

        btnDisconnect.Enabled = False
        txtDataToSend.ReadOnly = True
        CompassRoseBox.Enabled = False
        btnSend.Enabled = False
        Button1.Enabled = False
        Button2.Enabled = False
        Button3.Enabled = False
        Button4.Enabled = False
        Button5.Enabled = False
        Button6.Enabled = False
        Button7.Enabled = False
        Button8.Enabled = False
        'vsport.Enabled = False
        MeHereWindow.Hide()
        MeHereWindow.Stop()
        ParserBusy = False


        httpd = New HTTPServer(7305)
        httpd.StartFile = InternalMapFile.Name
        httpd.RootDirectory = InternalMapFile.DirectoryName
        httpd.OverrideFile1 = New System.IO.FileInfo("/")
        httpd.OverrideFile2 = New System.IO.FileInfo("/xml/coords/")
        httpd.OverrideFile3 = New System.IO.FileInfo("/xml/status/")
        httpd.OverrideFile4 = New System.IO.FileInfo("/js/")
        httpd.OverrideString1 = CStr(BoxOText.Text) & vbCrLf
        ServerStarted = False






        '        txtDataToSend.Text = "@"

        CompassMoveBox.Checked = False



        ' Generate graphics
        CompassRoseBox.Enabled = True
        UpdateGraphics()
        CompassRoseBox.Enabled = False

        ZigZagMsg("Navcom AI by MKB")



    End Sub






    Public Sub ZigZagMsg(ByVal inputstr As String)

        If (lblMessage.Text.CompareTo(inputstr & " ")) Then
            lblMessage.Text = inputstr & " "
        ElseIf (lblMessage.Text.CompareTo(inputstr)) Then
            lblMessage.Text = inputstr
        Else
            lblMessage.Text = " " & inputstr
        End If
    End Sub

    Public Sub TxError()
        ZigZagMsg("Unable to send")
    End Sub


    Private Sub DataReceived( _
       ByVal sender As Object, _
       ByVal e As System.IO.Ports.SerialDataReceivedEventArgs) _
       Handles serialPort.DataReceived


        If ParserBusy = True Then Return ' experimental, ParserBusy means "we're parsing a nav string or printing a com string"

        Try
            '           txtDataReceived.Invoke(New myDelegate(AddressOf updateTextBox), New Object() {})
            txtDataReceived.Invoke(New myDelegate(AddressOf updateTextBox), Nothing) 'New Object() {})
        Catch
            MsgBox("Error with parser")
        End Try



    End Sub

    Private Sub btnSend_Click( _
       ByVal sender As System.Object, _
       ByVal e As System.EventArgs) _
       Handles btnSend.Click

        txtDataToSend.AppendText(vbCrLf)
        Return

    End Sub


    Public Function TurnFunction(ByVal actualV As Double, ByVal wantedV As Double)

        Dim Actual As Double = actualV Mod 360
        Dim Wanted As Double = wantedV Mod 360
        Dim Result As Double = 0

        Dim Sign As Boolean

        Sign = (((Actual > 180) And (Wanted < 180)) Or ((Actual < 180) And (Wanted > 180)))
        Result = Wanted - Actual

        If (Math.Abs(Result) > 180) Then
            Result = 360 - Math.Abs(Result)
        End If
        If (Sign) Then
            Result = Result * -1
        End If

        Return Result


    End Function

    Public Function DisplayNice(ByVal thingy As Object, Optional ByVal digits As Integer = 5)
        Dim RetStr As String
        Try
            RetStr = CStr(thingy).Substring(0, digits)
        Catch ex As Exception
            RetStr = CStr(thingy)
        End Try
        Return RetStr

    End Function

    Public Sub UpdateGraphics()

        '   MeHereWindow.Update()
        '  MeHereWindow.Refresh()



        Using purplePen As New Pen(Color.Pink), _
    formGraphics As Graphics = CompassRoseBox.CreateGraphics()
            Dim redPen As New Pen(Color.Red)
            Dim bluePen As New Pen(Color.Yellow, 7.0)
            Dim yellowPen As New Pen(Color.Blue, 5.0)
            Dim blackPen As New Pen(Color.Black, 3.0)
            Dim greenPen As New Pen(Color.Green, 1.0)
            Dim brownPen As New Pen(Color.Brown, 3.0)


            Dim x As Integer
            Dim y As Integer

            CompassRoseBox.SendToBack()

            Dim CompassMove = HeadingAngle * (CompassMoveBox.Checked() = True)

            redPen.Width() = 2.0
            purplePen.Width() = 2.0

            x = xComp(CompassMove, CompassRoseRadius)
            y = yComp(CompassMove, CompassRoseRadius)

            formGraphics.FillRectangle(Brushes.Silver, New Rectangle(CompassRoseCX - 120, CompassRoseCY - 150, 2 * 150, 2 * 150))
            'formGraphics.FillEllipse(Brushes.Gray, New Rectangle(CompassRoseCX - 100, CompassRoseCY - 100, 2 * 100, 2 * 100))
            formGraphics.DrawEllipse(blackPen, New Rectangle(CompassRoseCX - 100, CompassRoseCY - 100, 2 * 100, 2 * 100))



            purplePen.Width() = 12.0
            formGraphics.DrawLine(purplePen, CompassRoseCX + CInt(x * 0.8), CompassRoseCY + CInt(y * 0.8), CompassRoseCX + CInt(x * 0.85), CompassRoseCY + CInt(y * 0.85))
            purplePen.Width() = 10.0
            formGraphics.DrawLine(purplePen, CompassRoseCX + CInt(x * 0.8), CompassRoseCY + CInt(y * 0.8), CompassRoseCX + CInt(x * 0.9), CompassRoseCY + CInt(y * 0.9))
            purplePen.Width() = 8.0
            formGraphics.DrawLine(purplePen, CompassRoseCX + CInt(x * 0.8), CompassRoseCY + CInt(y * 0.8), CompassRoseCX + CInt(x * 0.95), CompassRoseCY + CInt(y * 0.95))
            purplePen.Width() = 6.0
            formGraphics.DrawLine(purplePen, CompassRoseCX + CInt(x * 0.8), CompassRoseCY + CInt(y * 0.8), CompassRoseCX + CInt(x * 1.0), CompassRoseCY + CInt(y * 1.0))
            purplePen.Width() = 4.0
            formGraphics.DrawLine(purplePen, CompassRoseCX + CInt(x * 0.8), CompassRoseCY + CInt(y * 0.8), CompassRoseCX + CInt(x * 1.05), CompassRoseCY + CInt(y * 1.05))
            purplePen.Width() = 2.0
            formGraphics.DrawLine(purplePen, CompassRoseCX + CInt(x * 0.8), CompassRoseCY + CInt(y * 0.8), CompassRoseCX + CInt(x * 1.1), CompassRoseCY + CInt(y * 1.1))

            formGraphics.DrawString("N", New Font("Arial", 10.0!, FontStyle.Bold), Brushes.Purple, CompassRoseCX + CInt(x * 1.15) - 6, CompassRoseCY + CInt(y * 1.15) - 8)
            formGraphics.DrawString("S", New Font("Arial", 10.0!, FontStyle.Bold), Brushes.Purple, CompassRoseCX - CInt(x * 1.15) - 6, CompassRoseCY - CInt(y * 1.15) - 8)

            formGraphics.DrawLine(purplePen, CompassRoseCX, CompassRoseCY, CompassRoseCX + x, CompassRoseCY + y)
            formGraphics.DrawLine(purplePen, CompassRoseCX, CompassRoseCY, CompassRoseCX - x, CompassRoseCY - y)

            x = xComp(CompassMove + 90, CompassRoseRadius)
            y = yComp(CompassMove + 90, CompassRoseRadius)

            formGraphics.DrawLine(purplePen, CompassRoseCX, CompassRoseCY, CompassRoseCX + x, CompassRoseCY + y)
            formGraphics.DrawLine(purplePen, CompassRoseCX, CompassRoseCY, CompassRoseCX - x, CompassRoseCY - y)
            formGraphics.DrawString("E", New Font("Arial", 10.0!, FontStyle.Bold), Brushes.Purple, CompassRoseCX + CInt(x * 1.15) - 6, CompassRoseCY + CInt(y * 1.15) - 8)
            formGraphics.DrawString("W", New Font("Arial", 10.0!, FontStyle.Bold), Brushes.Purple, CompassRoseCX - CInt(x * 1.15) - 6, CompassRoseCY - CInt(y * 1.15) - 8)



            If HeadingBox.Enabled And HeadingAngle > -9999 Then
                x = xComp(HeadingAngle + CompassMove, CompassRoseRadius)
                y = yComp(HeadingAngle + CompassMove, CompassRoseRadius)
                formGraphics.DrawLine(bluePen, CompassRoseCX, CompassRoseCY, CompassRoseCX + x, CompassRoseCY + y)
            End If
            If BearingBox.Enabled And BearingAngle > -9999 Then
                x = xComp(BearingAngle + CompassMove, CompassRoseRadius)
                y = yComp(BearingAngle + CompassMove, CompassRoseRadius)
                formGraphics.DrawLine(yellowPen, CompassRoseCX, CompassRoseCY, CompassRoseCX + x, CompassRoseCY + y)
            End If
            If TrackingBox.Enabled And TrackingAngle > -9999 Then
                x = xComp(TrackingAngle + CompassMove, CompassRoseRadius)
                y = yComp(TrackingAngle + CompassMove, CompassRoseRadius)
                formGraphics.DrawLine(brownPen, CompassRoseCX, CompassRoseCY, CompassRoseCX + x, CompassRoseCY + y)
            End If
            If WindBox.Enabled And WindDir > -9999 Then
                x = xComp(HeadingAngle + WindDir + CompassMove, CompassRoseRadius)
                y = yComp(HeadingAngle + WindDir + CompassMove, CompassRoseRadius)
                formGraphics.DrawLine(greenPen, CompassRoseCX, CompassRoseCY, CompassRoseCX + x, CompassRoseCY + y)
            End If

            formGraphics.FillEllipse(Brushes.Black, New Rectangle(CompassRoseCX - 6, CompassRoseCY - 6, 12, 12))


            purplePen.Dispose()
            redPen.Dispose()
            blackPen.Dispose()
            brownPen.Dispose()
            yellowPen.Dispose()
            greenPen.Dispose()

            formGraphics.Dispose()

        End Using


        If (AltBar.Enabled = False And Altitude > -9999) Then
            If (Altitude < 1) Then
                AltBar.Value = 0
            ElseIf (Altitude > 70) Then
                AltBar.Value = 700
            Else
                AltBar.Value = CInt(Altitude * 10.0)
            End If
        End If

        If (BearingAngle > -9999 And HeadingAngle > -9999) Then
            Dim LastTurn As Double = TurnAmount
            Dim TempTurn As Double = TurnFunction(BearingAngle, HeadingAngle) ' move this to main

            If Not ( _
                  (LastTurn > (180.0 - TurnHysteresis)) And (TempTurn < (-180.0 + TurnHysteresis)) _
                  Or _
                  (TempTurn > (180.0 - TurnHysteresis)) And (LastTurn < (-180.0 + TurnHysteresis)) _
                   ) Then

                TurnAmount = TempTurn
            End If


            Dim TurnBarAmount As Double = TurnAmount * 3
            If TurnBarAmount > 180 Then TurnBarAmount = 180
            If TurnBarAmount < -180 Then TurnBarAmount = -180

            TurnBox.Enabled = True
            TurnBar.Show()
            TurnBar.Value = 180 + TurnBarAmount
            Using bluePen As New Pen(Color.Yellow, 3.0), _
            formGraphics3 As Graphics = TurnBar.CreateGraphics()
                formGraphics3.DrawLine(bluePen, 100, 0, 100, 42)
            End Using

        Else
            TurnBar.Value = 180
            TurnBar.Hide()
            TurnBox.Enabled = False
            Using bluePen As New Pen(Color.Silver, 3.0), _
            formGraphics3 As Graphics = TurnBar.CreateGraphics()
                formGraphics3.DrawLine(bluePen, 100, 0, 100, 42)
            End Using
        End If

        If (DistBar.Enabled = True And Distance > -9999) Then
            If (Distance < 1) Then
                DistBar.Value = 100
            ElseIf (Distance > 99) Then
                DistBar.Value = 0
            Else
                DistBar.Value = 100.0 - CInt(Distance)
            End If
        End If



        ' update text boxes
        With HeadingBox
            If .Enabled Then
                .Clear()
                If HeadingAngle > -9999 Then
                    .AppendText(DisplayNice((HeadingAngle + 360.0) Mod 360.0))
                Else
                    .AppendText("No data")
                End If

            End If
        End With
        With BearingBox
            If .Enabled Then
                .Clear()
                If BearingAngle > -9999 Then
                    .AppendText(DisplayNice((BearingAngle + 360.0) Mod 360.0))
                Else
                    .AppendText("No data")
                End If
            End If
        End With
        With SpeedBox
            If .Enabled Then
                .Clear()
                If Speed > -9999 Then
                    .AppendText(DisplayNice(Speed)) 'CStr(Speed))
                Else
                    .AppendText("No data")
                End If
            End If
        End With
        With TurnBox
            If .Enabled Then
                .Show()
                .Clear()
                If TurnAmount > -9999 Then
                    .AppendText(DisplayNice(Math.Abs(TurnAmount)))
                    If TurnAmount > 0 Then .AppendText(" L")
                    If TurnAmount < 0 Then .AppendText(" R")
                Else
                    .AppendText("No data")
                End If
            Else
                .Hide()
            End If
        End With
        With DistBox
            If .Enabled Then
                .Clear()
                If Distance > -9999 Then
                    .AppendText(DisplayNice(Distance))
                Else
                    .AppendText("No data")
                End If
            End If
        End With
        With TrackingBox
            If .Enabled Then
                .Clear()
                If TrackingAngle > -9999 Then
                    .AppendText(DisplayNice((TrackingAngle + 360.0) Mod 360.0))
                Else
                    .AppendText("No data")
                End If
            End If
        End With

        With LonBox
            If .Enabled Then
                .Clear()
                If LonVal <> -9999 Then
                    .Show()
                    .AppendText(CStr(CoordToDegs(Math.Abs(LonVal))))
                    .AppendText("' ")
                    .AppendText(DisplayNice(CoordToMins(Math.Abs(LonVal)), 7))
                    .AppendText("''")
                    '                        .AppendText(CStr(Math.Abs(LonVal) / 10000.0) & " W")
                    If (LonVal < 0) Then
                        .AppendText(" W")
                    Else
                        .AppendText(" E")
                    End If

                End If


            Else
                .AppendText("No data")
            End If
        End With
        With LatBox
            If .Enabled Then
                .Clear()
                If LatVal <> -9999 Then
                    .Show()
                    .AppendText(CStr(CoordToDegs(Math.Abs(LatVal))))
                    .AppendText("' ")
                    .AppendText(DisplayNice(CoordToMins(Math.Abs(LatVal)), 7))
                    .AppendText("''")
                    '                        .AppendText(CStr(Math.Abs(LonVal) / 10000.0) & " W")
                    If (LatVal < 0) Then
                        .AppendText(" S")
                    Else
                        .AppendText(" N")
                        '   .AppendText(CStr(Math.Abs(LatVal) / 10000.0) & " S")
                        '  .AppendText(CStr(LatVal / 10000.0) & " N")
                    End If
                End If
            Else
                .AppendText("No data")
            End If

        End With

        With ExtraBox1
            If .Enabled Then
                .Clear()
                If ExtraVal1 > -9999 Then
                    .AppendText(CStr(ExtraVal1))
                Else
                    .AppendText("No data")
                End If
            End If
        End With
        With ExtraBox2
            If .Enabled Then
                .Clear()
                If ExtraVal2 > -9999 Then
                    .AppendText(CStr(ExtraVal2))
                Else
                    .AppendText("No data")
                End If
            End If
        End With
        With ExtraBox3
            If .Enabled Then
                .Clear()
                If ExtraVal3 > -9999 Then
                    .AppendText(CStr(ExtraVal3))
                Else
                    .AppendText("No data")
                End If
            End If
        End With
        With WindBox
            If .Enabled Then
                RelWindBox.Clear()
                .Clear()
                If WindDir > -9999 Then
                    RelWindBox.AppendText(CStr(WindDir))
                    .AppendText(CStr((HeadingAngle + WindDir + 360.0) Mod 360.0))
                Else
                    .AppendText("No data")
                    RelWindBox.AppendText("No data")
                End If
            End If
        End With
        With AltBox
            If .Enabled Then
                .Clear()
                If Altitude > -9999 Then
                    .AppendText(CStr(Altitude))
                Else
                    .AppendText("No data")
                End If
            End If
        End With
        With WPBox
            If .Enabled Then
                .Clear()
                If Waypoint > -9999 Then
                    .AppendText(CStr(Waypoint))
                Else
                    .AppendText("...")
                End If
            End If
        End With


    End Sub
    ' this is what does all the work really



    Public Delegate Sub myDelegate()
    Public Sub updateTextBox()

        serialPort.ReadTimeout = 250
        If (serialPort.IsOpen = False) Then Return


        ' note the stupidity of having two serial LIFO buffers, made necessary by the fact that you can't read a non-ascii string otherwise

        While (serialPort.BytesToRead > 0) And ParserBusy = False
            ByteBuffer(ByteIndex) = serialPort.ReadByte
            If ByteBuffer(ByteIndex) > 15 And ByteBuffer(ByteIndex) < 30 Then
                txtLastLine.AppendText(ChrW(32)) ' ugly fix for spurious packet issue
                'ByteIndex = 1
            Else
                txtLastLine.AppendText(ChrW(ByteBuffer(ByteIndex)))
            End If


            'If ByteBuffer(ByteIndex) = 13 Then ParserBusy = True
            'If ByteBuffer(ByteIndex) = 10 And ByteIndex > 9 Then ParserBusy = True
            If ByteBuffer(ByteIndex) = 10 Then ParserBusy = True


            If ByteBuffer(ByteIndex) > 15 And ByteBuffer(ByteIndex) < 30 Then
                ByteIndex = ByteIndex
            Else
                ByteIndex += 1
            End If

            If ByteIndex < 0 Then ByteIndex = 0 ' this should never happen, but let's avoid breaking the buffer
            If ByteIndex > 512 Then ByteIndex = 0 ' this should never happen, but let's avoid breaking the buffer
        End While


        If (ParserBusy = True) Then ' ParserBusy = true stops the serial buffer and does calculations
            UpdateTextBox2()
            UpdateGraphics()
            ByteIndex = 512
            ' flush this just in case
            While ByteIndex > 0
                ByteBuffer(ByteIndex) = 0
                ByteIndex -= 1
            End While
            ByteIndex = 0
            ParserBusy = False

            If (serialPort.BytesToRead > 0) Then
                updateTextBox()
            End If
        End If









    End Sub

    Public Function DegSin(ByVal angle As Double)
        Return Math.Sin(((angle + 360) Mod 360) * Math.PI / 180.0)
    End Function


    Public Function DegCos(ByVal angle As Double)
        Return Math.Cos(((angle + 360) Mod 360) * Math.PI / 180.0)
    End Function

    Public Function xComp(ByVal angle As Double, ByVal mag As Double)
        Return CInt(Math.Sin(((angle + 360) Mod 360) * Math.PI / 180.0) * mag)
    End Function
    Public Function yComp(ByVal angle As Double, ByVal mag As Double)
        Return CInt(Math.Cos(((angle + 360) Mod 360) * Math.PI / 180.0) * mag * -1)
    End Function

    Public Sub UpdateTextBox2()



        ' Update last line (horribly inefficient but I need it for debugging!)
        With txtLastLine
            '           .AppendText(ComBuffer)


            If .Text.Contains(Chr(10)) Then 'Or .Text.Contains(crstring) Then
                LastLineString = String.Copy(.Text)
                .Clear()


                ' Parse last valid packet
                If (LastLineString.Contains("!!") = False) Then


                    ' avoid drawing the cursor and possible local echos

                    ' Update main text box
                    With txtDataReceived
                        '            .Font = New Font("Arial", 10.0!, FontStyle.Bold)
                        .SelectionColor = Color.Black 'Red
                        .AppendText(LastLineString) 'serialPort.ReadExisting)
                        .ScrollToCaret()
                    End With
                    ZigZagMsg("Received COM Packet: " & CStr(ByteIndex))






                Else
                    Dim Noffset = LastLineString.IndexOf("!!")
                    .AppendText(LastLineString.Substring(0, Noffset))
                    .ScrollToCaret()
                    ZigZagMsg("Received NAV Packet: " & CStr(ByteIndex))



                    Dim offset As Integer

                    'LastLineString = String.Copy(LastLineString.ToLower)

                    ' Distribute values where necessary: note the try-catch (redundant?)

                    ' b- bearing
                    offset = LastLineString.IndexOf("h")
                    If (offset > -1) Then
                        Try
                            HeadingAngle = CDbl(LastLineString.Substring(offset + 1, 4)) / 10.0
                        Catch ex As Exception
                        End Try
                    End If

                    offset = LastLineString.IndexOf("H")
                    If (offset > -1) Then
                        HeadingAngle = DecodeFloat(HeadingAngle, ByteBuffer(offset + 1), ByteBuffer(offset + 2), ByteBuffer(offset + 3), ByteBuffer(offset + 4), ByteBuffer(offset + 5))
                    End If


                    ' h- heading
                    offset = LastLineString.IndexOf("b")
                    If (offset > -1) Then
                        Try
                            BearingAngle = CDbl(LastLineString.Substring(offset + 1, 4)) / 10.0
                        Catch ex As Exception
                        End Try
                    End If
                    offset = LastLineString.IndexOf("B")
                    If (offset > -1) Then
                        BearingAngle = DecodeFloat(BearingAngle, ByteBuffer(offset + 1), ByteBuffer(offset + 2), ByteBuffer(offset + 3), ByteBuffer(offset + 4), ByteBuffer(offset + 5))
                    End If

                    ' t- tracking
                    offset = LastLineString.IndexOf("t")
                    If (offset > -1) Then
                        Try
                            TrackingAngle = CDbl(LastLineString.Substring(offset + 1, 4)) / 10.0
                        Catch ex As Exception
                        End Try
                    End If
                    offset = LastLineString.IndexOf("T")
                    If (offset > -1) Then
                        TrackingAngle = DecodeFloat(TrackingAngle, ByteBuffer(offset + 1), ByteBuffer(offset + 2), ByteBuffer(offset + 3), ByteBuffer(offset + 4), ByteBuffer(offset + 5))
                    End If

                    ' a- altitude
                    offset = LastLineString.IndexOf("a")
                    If (offset > -1) Then
                        Try
                            Altitude = CDbl(LastLineString.Substring(offset + 1, 4)) / 10.0
                        Catch ex As Exception
                        End Try
                    End If
                    offset = LastLineString.IndexOf("A")
                    If (offset > -1) Then
                        Altitude = DecodeFloat(TrackingAngle, ByteBuffer(offset + 1), ByteBuffer(offset + 2), ByteBuffer(offset + 3), ByteBuffer(offset + 4), ByteBuffer(offset + 5))
                    End If

                    ' w- wind
                    offset = LastLineString.IndexOf("w")
                    If (offset > -1) Then
                        Try
                            WindDir = CDbl(LastLineString.Substring(offset + 1, 4)) / 10.0
                        Catch ex As Exception
                        End Try
                    End If
                    offset = LastLineString.IndexOf("W")
                    If (offset > -1) Then
                        WindDir = DecodeFloat(WindDir, ByteBuffer(offset + 1), ByteBuffer(offset + 2), ByteBuffer(offset + 3), ByteBuffer(offset + 4), ByteBuffer(offset + 5))
                    End If

                    ' s- speed
                    offset = LastLineString.IndexOf("s")
                    If (offset > -1) Then
                        Try
                            Speed = CDbl(LastLineString.Substring(offset + 1, 4)) / 10.0
                        Catch ex As Exception
                        End Try
                    End If
                    offset = LastLineString.IndexOf("S")
                    If (offset > -1) Then
                        Speed = DecodeFloat(Speed, ByteBuffer(offset + 1), ByteBuffer(offset + 2), ByteBuffer(offset + 3), ByteBuffer(offset + 4), ByteBuffer(offset + 5))
                    End If

                    ' d- distance
                    offset = LastLineString.IndexOf("d")
                    If (offset > -1) Then
                        Try
                            Distance = CDbl(LastLineString.Substring(offset + 1, 4)) / 10.0
                        Catch ex As Exception
                        End Try
                    End If
                    offset = LastLineString.IndexOf("D")
                    If (offset > -1) Then
                        Distance = DecodeFloat(Distance, ByteBuffer(offset + 1), ByteBuffer(offset + 2), ByteBuffer(offset + 3), ByteBuffer(offset + 4), ByteBuffer(offset + 5))
                    End If

                    ' x- extra value 1
                    offset = LastLineString.IndexOf("x")
                    If (offset > -1) Then
                        Try
                            ExtraVal1 = CDbl(LastLineString.Substring(offset + 1, 4)) / 10.0
                        Catch ex As Exception
                        End Try
                    End If
                    offset = LastLineString.IndexOf("X")
                    If (offset > -1) Then

                        'ExtraVal1 = Asc(LastLineString.Chars(offset + 1)) 'CDbl(DecodeLong(LastLineString.Substring(offset + 1, 5)))
                        'txtDataReceived.AppendText(Chr(ByteBuffer(offset)))

                        ExtraVal1 = DecodeFloat(ExtraVal1, ByteBuffer(offset + 1), ByteBuffer(offset + 2), ByteBuffer(offset + 3), ByteBuffer(offset + 4), ByteBuffer(offset + 5))
                    End If



                    ' y- extra value 2
                    offset = LastLineString.IndexOf("y")
                    If (offset > -1) Then
                        Try
                            ExtraVal2 = CDbl(LastLineString.Substring(offset + 1, 4)) / 10.0
                        Catch ex As Exception
                        End Try
                    End If
                    offset = LastLineString.IndexOf("Y")
                    If (offset > -1) Then
                        Try
                            ExtraVal2 = DecodeFloat(ExtraVal2, ByteBuffer(offset + 1), ByteBuffer(offset + 2), ByteBuffer(offset + 3), ByteBuffer(offset + 4), ByteBuffer(offset + 5))
                        Catch ex As Exception
                        End Try
                    End If


                    ' z- extra value 3
                    offset = LastLineString.IndexOf("z")
                    If (offset > -1) Then
                        Try
                            ExtraVal3 = CDbl(LastLineString.Substring(offset + 1, 4)) / 10.0
                        Catch ex As Exception
                        End Try
                    End If
                    offset = LastLineString.IndexOf("Z")
                    If (offset > -1) Then
                        Try
                            ExtraVal3 = DecodeFloat(ExtraVal3, ByteBuffer(offset + 1), ByteBuffer(offset + 2), ByteBuffer(offset + 3), ByteBuffer(offset + 4), ByteBuffer(offset + 5))
                        Catch ex As Exception
                        End Try
                    End If


                    ' n- nav point is always in int format, cheaper?
                    offset = LastLineString.IndexOf("n")
                    If (offset > -1) Then
                        Try
                            Waypoint = CInt(LastLineString.Substring(offset + 1, 2))
                        Catch ex As Exception
                        End Try
                    End If

                    ' l- lights
                    offset = LastLineString.IndexOf("l")
                    If (offset > -1) Then
                        BitDisplay(CInt(LastLineString.Substring(offset + 1, 2)))
                    End If



                    ' latitude and longitude (binary only)

                    offset = LastLineString.IndexOf("I")
                    If (offset > -1) Then
                        Try
                            LatVal = DecodeLong(LatVal, ByteBuffer(offset + 1), ByteBuffer(offset + 2), ByteBuffer(offset + 3), ByteBuffer(offset + 4), ByteBuffer(offset + 5))
                            If (LatVal < 0) Then LatVal = -(2147483648 + LatVal)
                        Catch ex As Exception
                            MsgBox(LatVal)
                        End Try

                    End If

                    offset = LastLineString.IndexOf("J")
                    If (offset > -1) Then
                        Try
                            LonVal = DecodeLong(LonVal, ByteBuffer(offset + 1), ByteBuffer(offset + 2), ByteBuffer(offset + 3), ByteBuffer(offset + 4), ByteBuffer(offset + 5))
                            If (LonVal < 0) Then LonVal = -(2147483648 + LonVal)
                        Catch ex As Exception
                            MsgBox(LonVal)
                        End Try

                    End If

                    ' latitude and longitude (binary only)

                    offset = LastLineString.IndexOf("K")
                    If (offset > -1) Then
                        Try
                            LatValWP = DecodeLong(LatVal, ByteBuffer(offset + 1), ByteBuffer(offset + 2), ByteBuffer(offset + 3), ByteBuffer(offset + 4), ByteBuffer(offset + 5))
                            If (LatValWP < 0) Then LatValWP = -(2147483648 + LatValWP)
                        Catch ex As Exception
                            MsgBox(LatValWP)
                        End Try

                    End If

                    offset = LastLineString.IndexOf("L")
                    If (offset > -1) Then
                        Try
                            LonValWP = DecodeLong(LonValWP, ByteBuffer(offset + 1), ByteBuffer(offset + 2), ByteBuffer(offset + 3), ByteBuffer(offset + 4), ByteBuffer(offset + 5))
                            If (LonValWP < 0) Then LonVal = -(2147483648 + LonValWP)
                        Catch ex As Exception
                            MsgBox(LonValWP)
                        End Try

                    End If

                    NMEAOutput()

                    Cycles += 1

                    ' update nav screen








                End If
                txtLastPacket.Text = String.Copy(LastLineString)
            Else


                LastLineString = String.Empty



            End If
        End With


    End Sub

    Private Sub btnConnect_Click( _
       ByVal sender As System.Object, _
       ByVal e As System.EventArgs) _
       Handles btnConnect.Click
        If serialPort.IsOpen Then
            serialPort.Close()
        End If
        Try
            With serialPort
                .PortName = cbbCOMPorts.Text
                .BaudRate = cbbCOMBaud.Text '2400
                .Parity = IO.Ports.Parity.None
                .DataBits = 8
                .StopBits = IO.Ports.StopBits.One
                ' .Encoding = System.Text.Encoding.Unicode
            End With
            serialPort.Open()
            serialPort.DiscardInBuffer()
            serialPort.DiscardOutBuffer()


            ZigZagMsg(cbbCOMPorts.Text & " connected.")
            btnConnect.Enabled = False
            btnDisconnect.Enabled = True
            txtDataToSend.ReadOnly = False
            btnSend.Enabled = True
            Button1.Enabled = True
            Button2.Enabled = True
            Button3.Enabled = True
            Button4.Enabled = True
            Button5.Enabled = True
            Button6.Enabled = True
            Button7.Enabled = True
            Button8.Enabled = True

            CompassRoseBox.Enabled = True



        Catch ex As Exception

            ZigZagMsg("Unable to open port " & serialPort.PortName)
            MsgBox(ex.ToString)
        End Try
    End Sub

    Private Sub btnDisconnect_Click( _
       ByVal sender As System.Object, _
       ByVal e As System.EventArgs) _
       Handles btnDisconnect.Click
        Try
            ' flush this just in case
            ByteIndex = 512
            While ByteIndex > 0
                ByteBuffer(ByteIndex) = 0
                ByteIndex -= 1
            End While
            txtLastLine.Text = ""


            Try

                serialPort.Close()
            Catch

            End Try



            ServerStop()
            ZigZagMsg(serialPort.PortName & " disconnected.")
            btnConnect.Enabled = True
            btnDisconnect.Enabled = False
            txtDataToSend.ReadOnly = True
            GPSOutBox.Text = "None" ' triggers nmea shutdown event, too
            btnSend.Enabled = False
            Button1.Enabled = False
            Button2.Enabled = False
            Button3.Enabled = False
            Button4.Enabled = False
            Button5.Enabled = False
            Button6.Enabled = False
            Button7.Enabled = False
            Button8.Enabled = False
            ByteBuffer(0) = 0 ' fixes out of band stupidity with serial buffer
            ByteBuffer(0) = 1
            CompassRoseBox.Enabled = False
            ParserBusy = False
        Catch ex As Exception
            MsgBox(ex.ToString)
            TxError()
        End Try
    End Sub

    Private Sub cbbCOMPorts_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cbbCOMPorts.TextChanged
        cbbCOMBaud.Show()
    End Sub

    Private Sub PictureBox1_Click_1(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CompassRoseBox.Click

        '        PictureBox1.Hide()
        CompassRoseBox.SendToBack()
        serialPort.DiscardInBuffer()
        Try
            SafeXmit("@TSN" & vbCrLf, serialPort) ' means "telemetry serial toggle"

        Catch ex As Exception
            TxError()

        End Try
        UpdateGraphics()

        ZigZagMsg("Serial telemetry requested")

    End Sub


    Private Sub txtDataToSend_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txtDataToSend.TextChanged
        Dim i As Integer
        Dim PreStr As String

        If (UseTXBuffer.Checked = False) Then PreStr = "@" Else PreStr = String.Empty

        ' begin CRLF fudge


        txtDataToSend.Text.Replace(crlfstring, crstring)
        txtDataToSend.Text.Replace(lfstring, crstring)
        If txtDataToSend.Text.Contains(Chr(13)) Then txtDataToSend.Text.Replace(Chr(10), Chr(32)) Else txtDataToSend.Text.Replace(Chr(10), Chr(13))

        If txtDataToSend.Text.EndsWith(Chr(13)) Then txtDataToSend.AppendText(Chr(10))

        ' end CRLF fudge


        i = txtDataToSend.Text.Length + 3

        If (UseTXBuffer.Checked Or (i > 63) Or txtDataToSend.Text.EndsWith(Chr(10))) Then
            Try

                SafeXmit(PreStr & txtDataToSend.Text, serialPort) ' & vbCrLf)

                If (UseTXBuffer.Checked = False) Then
                    ZigZagMsg("Sent COM Packet")
                Else
                    ZigZagMsg("Sent character")

                End If

                txtDataToSend.Text = String.Empty

            Catch ex As Exception
                'TxError()

            End Try


            'With txtDataReceived
            '   .SelectionColor = Color.Black
            '   .AppendText(txtDataToSend.Text & vbCrLf)
            '   .ScrollToCaret()
            'End With


        Else
            TXBufferSize.Value = i


        End If


    End Sub

    Private Sub UseTXBuffer_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles UseTXBuffer.CheckedChanged
        If UseTXBuffer.Checked Then
            TXBufferSize.Hide()
            btnSend.Hide()
            LabelAt.Hide()
            ZigZagMsg("TX buffer off")
            txtDataToSend.Text = String.Empty
        Else
            TXBufferSize.Show()
            btnSend.Show()
            LabelAt.Show()
            LabelAt.SendToBack()
            ZigZagMsg("TX buffer on")
        End If

    End Sub


    Public Sub SafeXmit(ByVal Str As String, ByRef port As Object, Optional ByVal recursion As Integer = 1)

        ' welcome to the ugliest hack ever - would you believe a loop screws things up?
        ' welcome to the ugliest hack ever - would you believe a loop screws things up?

        WaitForSerial()
        Try
            port.Write(Str)
        Catch ex As Exception
            If (recursion > 10) Then
                ZigZagMsg("Error on transmit")
            Else
                SafeXmit(Str, port, recursion + 1)
            End If
        End Try

    End Sub



    Private Sub Label10_DoubleClick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Label10.DoubleClick, Label10.Click
        If (DistBar.Enabled) Then
            DistBar.Hide()
            DistBar.Enabled() = False
        Else
            DistBar.Show()
            DistBar.Enabled = True
        End If
        UpdateGraphics()

    End Sub




    Private Sub HeadLabel_DoubleClick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles HeadLabel.DoubleClick, HeadLabel.Click
        If (BearingBox.Enabled) Then
            BearingBox.Hide()
            BearingBox.Enabled() = False
        Else
            BearingBox.Show()
            BearingBox.Enabled = True
        End If
        UpdateGraphics()

    End Sub

    Private Sub WindLabel_DoubleClick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles WindLabel.DoubleClick, WindLabel.Click
        If (WindBox.Enabled) Then
            WindBox.Hide()
            WindLabel1.Hide()
            WindLabel2.Hide()
            WindBox.Enabled() = False
            RelWindBox.Hide()
            RelWindBox.Enabled() = False
        Else
            WindLabel1.Show()
            WindLabel2.Show()
            WindBox.Show()
            WindBox.Enabled = True
            RelWindBox.Show()
            RelWindBox.Enabled = True
        End If
        UpdateGraphics()


    End Sub

    Private Sub BearLabel_DoubleClick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BearLabel.DoubleClick, BearLabel.Click
        If (HeadingBox.Enabled) Then
            HeadingBox.Hide()
            HeadingBox.Enabled() = False
        Else
            HeadingBox.Show()
            HeadingBox.Enabled = True
        End If
        UpdateGraphics()

    End Sub


    Private Sub TrackLabel_DoubleClick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TrackLabel.DoubleClick, TrackLabel.Click
        If (TrackingBox.Enabled) Then
            TrackingBox.Hide()
            TrackingBox.Enabled() = False
        Else
            TrackingBox.Show()
            TrackingBox.Enabled = True
        End If
        UpdateGraphics()

    End Sub

    Private Sub AltBox_DoubleClick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles AltBox.DoubleClick, Label15.DoubleClick, Label15.Click
        If (AltBar.Enabled) Then
            AltBar.Show()
            AltBar.Enabled() = False
        Else
            AltBar.Hide()
            AltBar.Enabled = True
        End If
        UpdateGraphics()

    End Sub

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click

        Try
            SafeXmit(TextBox1.Text & vbCrLf, serialPort)
            ZigZagMsg("Sent COM Macro 2")

        Catch ex As Exception
            TxError()
            '            MsgBox(ex.ToString)
        End Try

    End Sub

    Private Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button2.Click

        Try
            SafeXmit(TextBox2.Text & vbCrLf, serialPort)
            ZigZagMsg("Sent COM Macro 2")

        Catch ex As Exception
            TxError()
            '            MsgBox(ex.ToString)
        End Try


    End Sub

    Private Sub Button3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button3.Click

        Try
            SafeXmit(TextBox3.Text & vbCrLf, serialPort)
            ZigZagMsg("Sent COM Macro 3")

        Catch ex As Exception
            TxError()
            '            MsgBox(ex.ToString)
        End Try


    End Sub

    Private Sub Button4_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button4.Click

        Try
            SafeXmit(TextBox4.Text & vbCrLf, serialPort)
            ZigZagMsg("Sent COM Macro 4")

        Catch ex As Exception
            TxError()
            '            MsgBox(ex.ToString)
        End Try


    End Sub

    Private Sub Button5_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button5.Click

        Try
            SafeXmit(TextBox5.Text & vbCrLf, serialPort)
            ZigZagMsg("Sent COM Macro 5")

        Catch ex As Exception
            TxError()
            '            MsgBox(ex.ToString)
        End Try


    End Sub

    Private Sub Button6_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button6.Click

        Try
            SafeXmit(TextBox6.Text & vbCrLf, serialPort)
            ZigZagMsg("Sent COM Macro 6")

        Catch ex As Exception
            TxError()
            '            MsgBox(ex.ToString)
        End Try


    End Sub


    Private Sub Button7_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button7.Click

        Try
            SafeXmit(TextBox7.Text & vbCrLf, serialPort)
            ZigZagMsg("Sent COM Macro 7")

        Catch ex As Exception
            TxError()
            '            MsgBox(ex.ToString)
        End Try

    End Sub


    Private Sub Button8_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button8.Click

        Try
            SafeXmit(TextBox8.Text & vbCrLf, serialPort)
            ZigZagMsg("Sent COM Macro 8")

        Catch ex As Exception
            TxError()
            '            MsgBox(ex.ToString)
        End Try

    End Sub

    Private Sub Label_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Label5.DoubleClick, Label4.DoubleClick
        ZigZagMsg("NavCom AI by MKB")

        'MeHereWindow.Refresh()
        WebBrowser1.Refresh()

        'ZigZagMsg(CStr(DecodeLong(0, &H84, &H83, &H82, &H81, &HA0)))

    End Sub

    Private Sub Form1_Activated(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Activated, MyBase.ResizeEnd, MyBase.Click
        UpdateGraphics()
    End Sub

    Public Sub BitDisplay(ByVal Feed As Integer)

        If Feed < 0 Then Return


        If (Feed <> 32) Then
            PictureBox3.Show()
            PictureBox3.SendToBack()
            PictureBox4.Show()
            PictureBox4.SendToBack()
            PictureBox5.Show()
            PictureBox5.SendToBack()
            PictureBox6.Show()
            PictureBox6.SendToBack()
            PictureBox7.Show()
            PictureBox7.SendToBack()
        End If


        'If (Feed And 128) Then PictureBox15.Show() Else PictureBox15.Hide()
        'If (Feed And 64) Then PictureBox14.Show() Else PictureBox14.Hide()
        'If (Feed And 32) Then PictureBox13.Show() Else PictureBox13.Hide()
        If (Feed And 32) Then My.Computer.Audio.PlaySystemSound(System.Media.SystemSounds.Exclamation)



        If (Feed And 16) Then PictureBox12.Show() Else PictureBox12.Hide()
        If (Feed And 8) Then PictureBox11.Show() Else PictureBox11.Hide()
        If (Feed And 4) Then PictureBox10.Show() Else PictureBox10.Hide()
        If (Feed And 2) Then PictureBox9.Show() Else PictureBox9.Hide()
        If (Feed And 1) Then PictureBox8.Show() Else PictureBox8.Hide()
        '        If (Feed And 256) Then My.Computer.Audio.PlaySystemSound(System.Media.SystemSounds.Exclamation)

    End Sub


    Public Function CoordToDegs(ByVal Coord As Double)

        Dim Temp As Double
        Temp = Coord / 10000
        Temp = Math.Truncate(Temp / 60)
        Return Temp

    End Function

    Public Function CoordToMins(ByVal Coord As Double)
        Dim Temp As Double
        Dim Deg As Integer
        Deg = Math.Truncate(Math.Truncate(Coord / 60) / 10000) * 60
        Temp = Coord / 10000
        Temp = Temp - Deg
        Return Temp

    End Function

    Public Function DecodeFloat(ByVal PrevVal As Double, ByVal Char0 As Integer, ByVal Char1 As Integer, ByVal Char2 As Integer, ByVal Char3 As Integer, ByVal Char4 As Integer)
        Dim Temp As Int32


        Temp = (DecodeLong(-666333, Char0, Char1, Char2, Char3, Char4))

        If Temp = -666333 Then
            Return PrevVal
        End If
        Dim Bar As Byte()
        ReDim Bar(4)

        Bar = System.BitConverter.GetBytes(Temp)

        ' needs checksum control


        Return CDbl(System.BitConverter.ToSingle(Bar, 0))

    End Function

    Public Function DecodeLong(ByVal PrevVal As Integer, ByVal Char0 As Integer, ByVal Char1 As Integer, ByVal Char2 As Integer, ByVal Char3 As Integer, ByVal Char4 As Integer)

        If Char4 < 128 Or Char3 < 128 Or Char2 < 128 Or Char1 < 128 Or Char0 < 128 Then Return PrevVal

        Dim ResLong As Int64
        Dim Checksum As Integer

        Try




            If ((Char4 And 1) = 0) Then Char0 = (Char0 And 127)
            If ((Char4 And 2) = 0) Then Char1 = (Char1 And 127)
            If ((Char4 And 4) = 0) Then Char2 = (Char2 And 127)
            If ((Char4 And 8) = 0) Then Char3 = (Char3 And 127)
            '        Char0 += 128 * (Char4 And 1 = True)
            '        Char1 = (Char1 And 127)
            '        Char1 += 128 * (Char4 And 2 = True)
            '        Char2 = (Char2 And 127)
            '        Char2 += 128 * (Char4 And 4 = True)
            '        Char3 = (Char3 And 127)
            '        Char3 += 128 * (Char4 And 8 = True)

            ResLong = Char3
            ResLong *= 256
            ResLong += Char2
            ResLong *= 256
            ResLong += Char1
            ResLong *= 256
            ResLong += Char0

            If (ResLong > 2147483647) Then
                ResLong = 2147483648 - ResLong
            End If

            Checksum = (Char4 And 112) / 16 ' checksum checksum checksum

            If (Checksum <> ((Char0 + Char1 + Char2 + Char3) Mod 8)) Then ResLong = PrevVal

        Catch ex As Exception
            ResLong = PrevVal
        End Try

        Return ResLong
    End Function



    Public Function DecodeNum(ByVal PrevVal As Integer, ByVal Char0 As Integer, ByVal Char1 As Integer, ByVal Char2 As Integer, ByVal Char3 As Integer, ByVal Char4 As Integer)

        If Char4 < 128 Or Char3 < 128 Or Char2 < 128 Or Char1 < 128 Or Char0 < 128 Then Return PrevVal

        Dim ResLong As Int32
        Dim ResDbl As Double
        Dim ResFloat As Single
        Dim Checksum As Integer

        Try




            If ((Char4 And 1) = 0) Then Char0 = (Char0 And 127)
            If ((Char4 And 2) = 0) Then Char1 = (Char1 And 127)
            If ((Char4 And 4) = 0) Then Char2 = (Char2 And 127)
            If ((Char4 And 8) = 0) Then Char3 = (Char3 And 127)
            '        Char0 += 128 * (Char4 And 1 = True)
            '        Char1 = (Char1 And 127)
            '        Char1 += 128 * (Char4 And 2 = True)
            '        Char2 = (Char2 And 127)
            '        Char2 += 128 * (Char4 And 4 = True)
            '        Char3 = (Char3 And 127)
            '        Char3 += 128 * (Char4 And 8 = True)


            ResLong = Char3
            ResLong *= 256
            ResLong += Char2
            ResLong *= 256
            ResLong += Char1
            ResLong *= 256
            ResLong += Char0

            If ((Char4 And 16) = 0) Then ' it's an integer
                If (ResLong > 2147483647) Then
                    ResLong = 2147483648 - ResLong
                End If
                ResDbl = CDbl(ResLong)
            Else 'it's a float
                Dim Bytes As Byte()
                ReDim Bytes(4)
                Bytes = System.BitConverter.GetBytes(ResLong)
                ResFloat = (System.BitConverter.ToSingle(Bytes, 0))
                ResDbl = CDbl(ResFloat)
            End If



            Checksum = (Char4 And 96) / 32 ' checksum checksum floatiness
            '            If (Checksum <> ((Char0 + Char1 + Char2 + Char3) Mod 4)) Then ResDbl = PrevVal

        Catch ex As Exception
            ResDbl = PrevVal
        End Try

        Return ResDbl
    End Function




    Private Sub GPSOutBox_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles GPSOutBox.TextChanged
        NMEALabel.Text = "NMEA"

        If (GPSOutBox.Text.CompareTo("None") And GPSOutBox.Text.CompareTo("Internal")) Then

            ' compareto is bass-ackwards: this is for an actual com port (real or virtual)

            Try
                If outputPort.IsOpen Then
                    outputPort.Close()
                End If
                With outputPort
                    .PortName = GPSOutBox.Text
                    .BaudRate = 4800 ' NMEA
                    .Parity = IO.Ports.Parity.None
                    .DataBits = 8
                    .StopBits = IO.Ports.StopBits.One
                    ' .Encoding = System.Text.Encoding.Unicode
                    .Open()
                    .DiscardInBuffer()
                    .DiscardOutBuffer()
                    ServerStop()
                    ZigZagMsg("NMEA output on " & outputPort.PortName)
                    NMEALabel.ForeColor = Color.Blue
                    NMEALabel.Font = New Font("Arial", 8.0!, FontStyle.Regular)
                    Me.WindowState = FormWindowState.Normal
                    NMEALabel.Enabled = True
                    NMEALabel.Cursor = Cursors.Default
                    ServerStop()

                End With

            Catch ex As Exception

                ZigZagMsg("Unable to open port " & outputPort.PortName)
                MsgBox(ex.ToString)
                MeHereWindow.Stop()
                MeHereWindow.Hide()
                NMEALabel.ForeColor = Color.Black
                NMEALabel.Enabled = False
                NMEALabel.Cursor = Cursors.Default

            End Try

            ' turn it off and go away

        ElseIf GPSOutBox.Text.CompareTo("Internal") Then

            If outputPort.IsOpen Then
                With outputPort
                    .Close()
                End With
            End If
            ZigZagMsg("NMEA port off")
            MeHereWindow.Stop()
            MeHereWindow.Hide()
            ServerStop()
            NMEALabel.Font = New Font("Arial", 8.0!, FontStyle.Regular)
            Me.WindowState = FormWindowState.Normal
            NMEALabel.ForeColor = Color.Black
            NMEALabel.Enabled = False
            NMEALabel.Cursor = Cursors.Default
        Else

            ' internal tracker formatted similar to MeHere code goes here

            If outputPort.IsOpen Then
                With outputPort
                    .Close()
                End With
            End If

            'WaitForSerial()
            MeHereWindow.Stop()
            MeHereWindow.Hide()
            ServerStart()
            ZigZagMsg("NMEA -> Internal map")
            NMEALabel.Text = "Map"
            NMEALabel.Font = New Font("Arial", 8.0!, FontStyle.Underline)
            NMEALabel.ForeColor = Color.Green
            NMEALabel.Enabled = True
            NMEALabel.Cursor = Cursors.Hand



        End If

    End Sub

    Public Sub WaitForSerial()
        Return
        Dim a As Integer = 0
        If (serialPort.IsOpen) Then
            While CInt(serialPort.BytesToRead > 0)
                a += 1
                If a > 200000 Then
                    Return
                End If
            End While
        End If
    End Sub

    Public Sub NMEAOutput()
        If outputPort.IsOpen Then
            NMEALabel.ForeColor = Color.White
            '            GPSOutBox.Enabled = False


            ' actual nmea out code goes here
            ' do we need other strings? maybe GPRMC? try with other
            ' moving map software


            GPGGA = "$GPGGA,"
            If (System.DateTime.UtcNow.Hour < 10) Then GPGGA &= "0"
            GPGGA &= CStr(System.DateTime.UtcNow.Hour)
            If (System.DateTime.UtcNow.Minute < 10) Then GPGGA &= "0"
            GPGGA &= CStr(System.DateTime.UtcNow.Minute)
            If (System.DateTime.UtcNow.Second < 10) Then GPGGA &= "0"
            GPGGA &= CStr(System.DateTime.UtcNow.Second)
            GPGGA &= ","
            GPGGA &= CStr(CoordToDegs(Math.Abs(LatVal)))
            GPGGA &= DisplayNice(CoordToMins(Math.Abs(LatVal + 0.0000000003)), 7)
            If LatVal > 0 Then GPGGA &= ",N," Else GPGGA &= ",S,"
            If ((CoordToDegs(Math.Abs(LonVal)) < 100)) Then GPGGA &= "0"
            GPGGA &= CStr(CoordToDegs(Math.Abs(LonVal)))
            GPGGA &= DisplayNice(CoordToMins(Math.Abs(LonVal + 0.0000000003)), 7)
            If LonVal > 0 Then GPGGA &= ",E," Else GPGGA &= ",W,"
            GPGGA &= "1,05,1.5,000.0,M,000.0,M, ,*" '*00" ' sat status, we don't really have it so make something up
            GPGGA &= GPSChecksum(GPGGA)
            If (outputPort.IsOpen) Then SafeXmit(GPGGA & vbCrLf, outputPort) 'outputPort.Write(GPGGA & vbCrLf)

            GPRMC = "$GPRMC,"
            If (System.DateTime.UtcNow.Hour < 10) Then GPRMC &= "0"
            GPRMC &= CStr(System.DateTime.UtcNow.Hour)
            If (System.DateTime.UtcNow.Minute < 10) Then GPRMC &= "0"
            GPRMC &= CStr(System.DateTime.UtcNow.Minute)
            If (System.DateTime.UtcNow.Second < 10) Then GPRMC &= "0"
            GPRMC &= CStr(System.DateTime.UtcNow.Second)
            GPRMC &= ",A,"
            GPRMC &= CStr(CoordToDegs(Math.Abs(LatVal)))
            GPRMC &= DisplayNice(CoordToMins(Math.Abs(LatVal + 0.0000000003)), 7)
            If LatVal > 0 Then GPRMC &= ",N," Else GPRMC &= ",S,"
            If ((CoordToDegs(Math.Abs(LonVal)) < 100)) Then GPRMC &= "0"
            GPRMC &= CStr(CoordToDegs(Math.Abs(LonVal)))
            GPRMC &= DisplayNice(CoordToMins(Math.Abs(LonVal + 0.0000000003)), 7)
            If LonVal > 0 Then GPRMC &= ",E," Else GPRMC &= ",W,"
            GPRMC &= GPSAngleForm(Speed * 1.94384449) ' meters per second >> knots
            GPRMC &= ","
            GPRMC &= GPSAngleForm(HeadingAngle)
            GPRMC &= ","
            If (System.DateTime.Today.Day < 10) Then GPRMC &= "0"
            GPRMC &= System.DateTime.Today.Day
            If (System.DateTime.Today.Month < 10) Then GPRMC &= "0"
            GPRMC &= System.DateTime.Today.Month
            If ((System.DateTime.Today.Year Mod 100) < 10) Then GPRMC &= "0"
            GPRMC &= (System.DateTime.Today.Year Mod 100)
            GPRMC &= "000.0,E*"
            GPRMC &= GPSChecksum(GPRMC)
            If (outputPort.IsOpen) Then SafeXmit(GPRMC & vbCrLf, outputPort) 'outputPort.Write(GPRMC & vbCrLf)

            'GPRMB = "$GPRMB,"

            ' do we want to extrapolate WP coordinates and also generate GPRMB? ugh... boring...


            outputPort.DiscardInBuffer() ' just in case

            'GPSOutBox.Enabled = True
            NMEALabel.ForeColor = Color.Blue
        ElseIf (NMEALabel.Text.CompareTo("NMEA")) Then ' remember that compareto is backwards

            Const qq As String = ControlChars.Quote

            httpd.OverrideString2 = String.Empty
            httpd.OverrideString2 = httpd.OverrideString2 & "<markers>" & vbCrLf & _
                                    "<marker lng=" & qq & DisplayNice((LonVal / 600000), 8) & qq & " lat=" & qq & DisplayNice((LatVal / 600000), 8) & qq & " name=" & qq & "Vehicle" & qq & " />" & vbCrLf & _
                                    "<marker lng=" & qq & DisplayNice((LonValWP / 600000), 8) & qq & " lat=" & qq & DisplayNice((LatValWP / 600000), 8) & qq & " name=" & qq & "Destination" & qq & " />" & vbCrLf & _
                                    "</markers>" & vbCrLf ' xml coords"

            If MeHereWindow.IsBusy = False Then

                WebBrowser1.Refresh()
            End If

            Return
        End If
    End Sub


    Function GPSAngleForm(ByVal var As Double) As String

        If (var > 999.9) Then Return "999.9"

        Dim tempstr As String = String.Empty
        If (Math.Truncate(var) < 10) Then tempstr &= "00"
        If (Math.Truncate(var) > 10 And Math.Truncate(var) < 100) Then tempstr &= "0"
        tempstr &= CStr(Math.Truncate(var))
        tempstr &= "."
        tempstr &= CStr(Math.Truncate((var * 10) Mod 10))
        Return tempstr


    End Function

    ' Calculates the checksum for a sentence
    Public Function GPSChecksum(ByVal sentence As String) As String
        ' Loop through all chars to get a checksum
        Dim Character As Char
        Dim Checksum As Integer
        For Each Character In sentence
            Select Case Character
                Case "$"c
                    ' Ignore the dollar sign
                Case "*"c
                    ' Stop processing before the asterisk
                    Exit For
                Case Else
                    ' Is this the first value for the checksum?
                    If Checksum = 0 Then
                        ' Yes. Set the checksum to the value
                        Checksum = Convert.ToByte(Character)
                    Else
                        ' No. XOR the checksum with this character's value
                        Checksum = Checksum Xor Convert.ToByte(Character)
                    End If
            End Select
        Next
        ' Return the checksum formatted as a two-character hexadecimal
        Return Checksum.ToString("X2")
    End Function

    Private Sub NMEALabel_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles NMEALabel.Click

        If (NMEALabel.Cursor = Cursors.Default) Then Return

        If (MeHereWindow.Visible = False) Then
            Try
                WaitForSerial()
                ServerStart()
                While ServerStarted = False

                End While
                MeHereWindow.Show()
                Me.WindowState = FormWindowState.Maximized
                ''MeHereWindow.Navigate("c:\index.html")
                MeHereWindow.Navigate("http://localhost:7305/")
            Catch Ex As Exception
                ServerStop()
                Me.WindowState = FormWindowState.Normal
                MeHereWindow.Stop()
                MeHereWindow.Hide()
            End Try

            '            MeHereWindow.Update()
        Else
            ServerStop()
            Me.WindowState = FormWindowState.Normal
            MeHereWindow.Stop()
            MeHereWindow.Hide()
        End If


    End Sub

    ' yes we have to do this 3 times to fix annoying memory leak on exit
    Public Sub Shutdown(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Disposed
        With sender
            'httpd.cServer.ServerKillFlag = True
            ServerStop()
            outputPort.Close()
            serialPort.Close()
            '            MsgBox("Closed!")
        End With
        'httpd.cServer.ServerKillFlag = True
        ServerStop()
        outputPort.Close()
        serialPort.Close()
        '        MsgBox("Closed!")
    End Sub

    Protected Overrides Sub Finalize()
        ServerStop()
        httpd.cServer.ServerKillFlag = True
        outputPort.Close()
        serialPort.Close()
        '        MsgBox("Closed!")
    End Sub


    Private Sub CheckBox1_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CompassMoveBox.CheckedChanged
        UpdateGraphics()
    End Sub

End Class