Imports System
Imports System.IO
Imports System.Net.Sockets
Imports System.Text
Imports Microsoft.Win32

'This is the base server class that all other server clasess use (Port 1000 Default)
Public Class BaseServer

    Public Port As Integer = 1000
    Public clients As New Hashtable()
    Public listener As TcpListener
    Public listenerThread As Threading.Thread
    Public Event StatusUpdate(ByVal sStatus As String)
    Public Event DataReceived(ByVal sender As UserConnection, ByVal Data As String)
    Public Event ClientConnected(ByVal sender As UserConnection)
    Public Event ClientDisConnected(ByVal sender As UserConnection)
    Public ServerKillFlag As Boolean = False


    Public Sub StartServer()
        ServerKillFlag = False
        listenerThread = New Threading.Thread(AddressOf DoListen)
        listenerThread.Start()
        RaiseEvent StatusUpdate("Server started")
    End Sub

    Public Sub StopServer()
        ServerKillFlag = True
        On Error Resume Next


        listener.Stop()
        Dim cUserConnection As UserConnection
        For Each cUserConnection In clients
            CloseClient(cUserConnection)
            cUserConnection.client.Close()

            clients.Remove(cUserConnection)
            OnClientConnect(cUserConnection)
        Next
        RaiseEvent StatusUpdate("Server stopped")

        'listenerThread.Abort()
        listener = Nothing
    End Sub

    Public Sub CloseClient(ByVal cUserConnection As UserConnection)
        On Error Resume Next
        Dim NWStream As NetworkStream = cUserConnection.client.GetStream
        NWStream.Close()
        cUserConnection.client.Close()
        clients.Remove(cUserConnection)
        OnClientConnect(cUserConnection)
    End Sub

    Private Sub DoListen()

        Try
            ' Listen for new connections.
            listener = New TcpListener(System.Net.IPAddress.Any, Port)
            listener.Start()
            Do
                Dim client As New UserConnection(listener.AcceptTcpClient)
                If clients.Contains(client) = False Then
                    clients.Add(client, client)
                    OnClientConnect(client)
                    AddHandler client.DataReceived, AddressOf OnDataReceived
                    AddHandler client.ClientClose, AddressOf OnClientDisconnect
                    'RaiseEvent StatusUpdate("New connection found: waiting for log-in")
                Else
                    client = Nothing
                End If

            Loop Until ServerKillFlag

        Catch ex As Exception

        End Try
    End Sub

    Public Sub OnDataReceived(ByVal sender As UserConnection, ByVal data As String)
        If Len(data) > 0 Then
            RaiseEvent DataReceived(sender, data)
        End If
    End Sub

    Public Sub OnClientConnect(ByVal sender As UserConnection)
        RaiseEvent ClientConnected(sender)
    End Sub

    Public Sub OnClientDisconnect(ByVal sender As UserConnection)
        On Error Resume Next
        sender.client.Close()
        clients.Remove(sender)
        sender = Nothing
        RaiseEvent ClientDisConnected(sender)
    End Sub

    Protected Overrides Sub Finalize()
        StopServer()
        clients = Nothing
        listener = Nothing
        MyBase.Finalize()
    End Sub

End Class

'The UserConnection class encapsulates the functionality of a TcpClient connection with streaming for a single user.
Public Class UserConnection
    Const READ_BUFFER_SIZE As Integer = 5120 '1024
    Public client As TcpClient
    Public sExtraData As String
    Public sExtraValues As ValueType
    Public readBuffer(READ_BUFFER_SIZE) As Byte
    Public Event DataReceived(ByVal sender As UserConnection, ByVal Data As String)
    Public Event ClientClose(ByVal sender As UserConnection)

    ' Overload the New operator to set up a read thread.
    Public Sub New(ByVal client As TcpClient)
        Me.client = client



        ' This starts the asynchronous read thread.  The data will be saved into
        Me.client.GetStream.BeginRead(readBuffer, 0, READ_BUFFER_SIZE, AddressOf StreamReceiver, Nothing) 'ew Object())
    End Sub

    Public Sub CloseClientConenction()
        Dim NWStream As NetworkStream = client.GetStream
        NWStream.Flush()
        client.Close()
        RaiseEvent ClientClose(Me)
    End Sub

    ' This subroutine uses a StreamWriter to send a message to the user.
    Public Sub SendData(ByVal Data As String)
        ' Synclock ensure that no other threads try to use the stream at the same time.
        SyncLock client.GetStream
            Dim writer As New IO.StreamWriter(client.GetStream)
            writer.Write(Data)

            ' Make sure all data is sent now.
            writer.Flush()
        End SyncLock
    End Sub

    Public Sub SendFile(ByVal sFilename As String)

        Dim NWStream As NetworkStream = client.GetStream
        Dim bytesToSend(client.SendBufferSize) As Byte
        Dim FI As New FileInfo(sFilename)
        Dim FileSTR As New FileStream(sFilename, FileMode.Open, FileAccess.Read)
        Dim FileReader As New BinaryReader(FileSTR)
        Dim numBytesRead As Integer
        Dim Ipos As Integer

        Do Until Ipos >= FI.Length
            numBytesRead = FileSTR.Read(bytesToSend, 0, bytesToSend.Length)
            NWStream.Write(bytesToSend, 0, numBytesRead)
            Ipos = Ipos + numBytesRead
            NWStream.Flush()
        Loop
        NWStream.Flush()
        FileSTR.Close()
        FileReader.Close()
    End Sub

    ' This is the callback function for TcpClient.GetStream.Begin. It begins an 
    ' asynchronous read from a stream.
    Private Sub StreamReceiver(ByVal ar As IAsyncResult)
        Dim BytesRead As Integer
        Dim strMessage As String
        Try
            ' Ensure that no other threads try to use the stream at the same time.
            SyncLock client.GetStream
                ' Finish asynchronous read into readBuffer and get number of bytes read.
                BytesRead = client.GetStream.EndRead(ar)
            End SyncLock

            If BytesRead < 1 Then
                RaiseEvent ClientClose(Me)
                Exit Sub
            End If
            If BytesRead < 1 Then
                Exit Sub
            End If

            ' Convert the byte array the message was saved into
            strMessage = Encoding.ASCII.GetString(readBuffer, 0, BytesRead)

            RaiseEvent DataReceived(Me, strMessage)

            ' Ensure that no other threads try to use the stream at the same time.
            SyncLock client.GetStream
                ' Start a new asynchronous read into readBuffer.

                client.GetStream.BeginRead(readBuffer, 0, READ_BUFFER_SIZE, AddressOf StreamReceiver, Nothing)
            End SyncLock

        Catch e As Exception
        End Try
    End Sub

    Protected Overrides Sub Finalize()
        RaiseEvent ClientClose(Me)
        MyBase.Finalize()
    End Sub


End Class

'Time server just sends the time to the client and disconnects them (Port 13 Default)
Public Class TimeServer
    Public WithEvents cServer As New BaseServer()
    Public Event StatusUpdate(ByVal sStatus As String)
    Public Event DataReceived(ByVal sender As UserConnection, ByVal Data As String)
    Public Event ClientConnected(ByVal sender As UserConnection)
    Public Event ClientDisConnected(ByVal sender As UserConnection)

    Private Sub cServer_ClientConnected(ByVal sender As UserConnection) Handles cServer.ClientConnected
        RaiseEvent ClientConnected(sender)
        sender.SendData(Now.ToUniversalTime)
        cServer.CloseClient(sender)
    End Sub

    Private Sub cServer_ClientDisConnected(ByVal sender As UserConnection) Handles cServer.ClientDisConnected
        RaiseEvent ClientDisConnected(sender)
    End Sub

    Private Sub cServer_DataReceived(ByVal sender As UserConnection, ByVal Data As String) Handles cServer.DataReceived
        RaiseEvent DataReceived(sender, Data)
    End Sub

    Private Sub cServer_StatusUpdate(ByVal sStatus As String) Handles cServer.StatusUpdate
        RaiseEvent StatusUpdate(sStatus)
    End Sub

    Public Sub StartServer()
        cServer.StartServer()
    End Sub

    Public Sub StopServer()
        cServer.StopServer()
    End Sub

    Public Sub New()
        cServer.Port = 13
    End Sub

    Protected Overrides Sub Finalize()
        On Error Resume Next
        cServer.StopServer()
        cServer = Nothing
        MyBase.Finalize()
    End Sub
End Class

'Echo Server just sends back what the client sent to us (Port 7 Default)
Public Class EchoServer

    Public WithEvents cServer As New BaseServer()
    Public Event StatusUpdate(ByVal sStatus As String)
    Public Event DataReceived(ByVal sender As UserConnection, ByVal Data As String)
    Public Event ClientConnected(ByVal sender As UserConnection)
    Public Event ClientDisConnected(ByVal sender As UserConnection)

    Private Sub cServer_ClientConnected(ByVal sender As UserConnection) Handles cServer.ClientConnected
        RaiseEvent ClientConnected(sender)
    End Sub

    Private Sub cServer_ClientDisConnected(ByVal sender As UserConnection) Handles cServer.ClientDisConnected
        RaiseEvent ClientDisConnected(sender)
    End Sub

    Private Sub cServer_DataReceived(ByVal sender As UserConnection, ByVal Data As String) Handles cServer.DataReceived
        'echo back the charactor typed if configured to do so
        sender.SendData(Data)
        RaiseEvent DataReceived(sender, Data)
    End Sub

    Private Sub cServer_StatusUpdate(ByVal sStatus As String) Handles cServer.StatusUpdate
        RaiseEvent StatusUpdate(sStatus)
    End Sub

    Public Sub StartServer()
        cServer.StartServer()
    End Sub

    Public Sub StopServer()
        cServer.StopServer()
    End Sub

    Public Sub New()
        cServer.Port = 7
    End Sub

    Protected Overrides Sub Finalize()
        On Error Resume Next
        cServer.StopServer()
        cServer = Nothing
        MyBase.Finalize()
    End Sub
End Class

'Telnet server reads data in and processes it when it occurs VBCRLF (Port 23 Default)
Public Class TelnetServer
    Public WelcomeMessage As String
    Public EchoMessage As Boolean = False

    Public WithEvents cServer As New BaseServer()
    Public Event StatusUpdate(ByVal sStatus As String)
    Public Event DataReceived(ByVal sender As UserConnection, ByVal Data As String)
    Public Event CommandReceived(ByVal sender As UserConnection, ByVal Data As String)
    Public Event ClientConnected(ByVal sender As UserConnection)
    Public Event ClientDisConnected(ByVal sender As UserConnection)

    Private Sub cServer_ClientConnected(ByVal sender As UserConnection) Handles cServer.ClientConnected
        RaiseEvent ClientConnected(sender)
        sender.SendData(WelcomeMessage)
    End Sub

    Private Sub cServer_ClientDisConnected(ByVal sender As UserConnection) Handles cServer.ClientDisConnected
        RaiseEvent ClientDisConnected(sender)
    End Sub

    Private Sub cServer_DataReceived(ByVal sender As UserConnection, ByVal Data As String) Handles cServer.DataReceived
        'echo back the charactor typed if configured to do so
        If EchoMessage = True Then
            If Data <> Chr(10) And Data <> Chr(13) Then
                sender.SendData(Data)
            End If
        End If

        RaiseEvent DataReceived(sender, Data)

        'get the data, check for VBCRLF and process the line
        If Data <> Chr(10) And Data <> Chr(13) And Data <> vbCrLf Then
            sender.sExtraData = sender.sExtraData & Data
        End If

        If Data = Chr(13) Or Data = Chr(10) Or Data = vbCrLf Then
            Replace(sender.sExtraData, Chr(10), "")
            Replace(sender.sExtraData, Chr(13), "")
            Replace(sender.sExtraData, vbCrLf, "")
            sender.sExtraData = Trim(sender.sExtraData)
            If sender.sExtraData <> "" Then
                RaiseEvent CommandReceived(sender, sender.sExtraData)
                sender.sExtraData = ""
            End If

        End If
    End Sub

    Private Sub cServer_StatusUpdate(ByVal sStatus As String) Handles cServer.StatusUpdate
        RaiseEvent StatusUpdate(sStatus)
    End Sub

    Public Sub StartServer()
        cServer.StartServer()
    End Sub

    Public Sub StopServer()
        cServer.StopServer()
    End Sub

    Public Sub New()
        cServer.Port = 23
        WelcomeMessage = "Welcome to my Telnet Server" & vbCrLf & vbCrLf
    End Sub

    Protected Overrides Sub Finalize()
        On Error Resume Next
        cServer.StopServer()
        cServer = Nothing
        MyBase.Finalize()
    End Sub
End Class

'HTTP Server sends back files requested by the browser (Port 80 Default)
'Note this only supports the GET command at this moment
Public Class HTTPServer

    Public Enum ResponseCodes
        HTTP_OK = 200
        HTTP_NOTFOUND = 404
        HTTP_SERVERERROR = 500
    End Enum

    Public Structure HTTPConnection
        Dim Request_Method As String
        Dim Request_Accept As String
        Dim Request_AcceptLanguage As String
        Dim Request_Encoding As String
        Dim Request_HTTPVersion As String
        Dim Request_Useragent As String
        Dim Request_Host As String
        Dim Request_Cookie As String
        Dim Request_Referer As String
        Dim Request_ConnectionType As String
        Dim Request_Filename As String
        Dim Request_LocalFilename As String
        Dim Request_LocalIsDir As Boolean
        Dim Response_Number As ResponseCodes
        Dim Response_Text As String
        Dim Response_ContentLength As Integer
        Dim Response_ContentType As String
        Dim Response_ServerType As String
        Dim Response_Handled As Boolean 'flag this as true if you are handling it yourself
    End Structure


    Public RootDirectory As String
    Public StartFile As String
    Public c As Char = " "
    Public OverrideString1 As New String(c, 8192)
    Public OverrideString2 As New String(c, 8192)
    Public OverrideString3 As New String(c, 8192)
    Public OverrideString4 As New String(c, 8192)
    Public OverrideString5 As New String(c, 8192)
    Public OverrideString6 As New String(c, 8192)
    Public OverrideString7 As New String(c, 8192)
    Public OverrideString8 As New String(c, 8192)
    Public OverrideString9 As New String(c, 8192)
    Public OverrideString10 As New String(c, 8192)
    Public OverrideFile1 As New FileInfo("\nonesiste")
    Public OverrideFile2 As New FileInfo("\nonesiste")
    Public OverrideFile3 As New FileInfo("\nonesiste")
    Public OverrideFile4 As New FileInfo("\nonesiste")
    Public OverrideFile5 As New FileInfo("\nonesiste")
    Public OverrideFile6 As New FileInfo("\nonesiste")
    Public OverrideFile7 As New FileInfo("\nonesiste")
    Public OverrideFile8 As New FileInfo("\nonesiste")
    Public OverrideFile9 As New FileInfo("\nonesiste")
    Public OverrideFile10 As New FileInfo("\nonesiste")




    Public WithEvents cServer As New BaseServer()
    Public Event StatusUpdate(ByVal sStatus As String)
    Public Event DataReceived(ByVal sender As UserConnection, ByVal Data As String)
    Public Event ON_HTTP_GET(ByVal sender As UserConnection, ByRef Data As HTTPConnection)
    Public Event ClientConnected(ByVal sender As UserConnection)
    Public Event ClientDisConnected(ByVal sender As UserConnection)

    Private Sub cServer_ClientConnected(ByVal sender As UserConnection) Handles cServer.ClientConnected
        RaiseEvent ClientConnected(sender)
    End Sub

    Private Sub cServer_ClientDisConnected(ByVal sender As UserConnection) Handles cServer.ClientDisConnected
        RaiseEvent ClientDisConnected(sender)
    End Sub

    Private Sub cServer_DataReceived(ByVal sender As UserConnection, ByVal Data As String) Handles cServer.DataReceived
        'get the request and send the data back to them
        Dim TConnection As HTTPConnection = New HTTPConnection
        Dim sData As String = Data
        'sender.SendData(Data)

        'ParseHTTPHeader(sData, TConnection)

        TConnection = ParseHTTPHeader2(sData)

        RaiseEvent ON_HTTP_GET(sender, TConnection)
        ServeHTTPData(sender, TConnection)
        RaiseEvent DataReceived(sender, Data)

        TConnection = Nothing

    End Sub

    Public Function SameFileInfo(ByVal F1 As FileInfo, ByVal F2 As FileInfo) As Boolean

        If (F1.Name = F2.Name) And (F1.DirectoryName = F2.DirectoryName) Then
            Return True
        Else
            Return False
        End If
    End Function

    Private Sub ServeHTTPData(ByVal cUserConnection As UserConnection, ByVal TConnection As HTTPConnection)
        If TConnection.Response_Handled = True Then Exit Sub
        Try
            Dim DI As New DirectoryInfo(TConnection.Request_LocalFilename)
            Dim FI As New FileInfo(TConnection.Request_LocalFilename)

            Debug.WriteLine(TConnection.Request_LocalFilename)

            Dim Overrideable As New String(c, 8192)
            Overrideable = String.Empty

            Debug.WriteLine(TConnection.Request_LocalFilename)


            If SameFileInfo(FI, OverrideFile1) Then Overrideable = OverrideString1
            If SameFileInfo(FI, OverrideFile2) Then Overrideable = OverrideString2
            If SameFileInfo(FI, OverrideFile3) Then Overrideable = OverrideString3
            If SameFileInfo(FI, OverrideFile4) Then Overrideable = OverrideString4
            If SameFileInfo(FI, OverrideFile5) Then Overrideable = OverrideString5
            If SameFileInfo(FI, OverrideFile6) Then Overrideable = OverrideString6
            If SameFileInfo(FI, OverrideFile7) Then Overrideable = OverrideString7
            If SameFileInfo(FI, OverrideFile8) Then Overrideable = OverrideString8
            If SameFileInfo(FI, OverrideFile9) Then Overrideable = OverrideString9
            If SameFileInfo(FI, OverrideFile10) Then Overrideable = OverrideString10


            If Overrideable <> String.Empty Then
                TConnection.Response_Number = ResponseCodes.HTTP_OK
                TConnection.Response_Text = "OK"
                ' hack, fix later
                If (Overrideable.Contains("<markers>")) Then
                    TConnection.Response_ContentType = "text/xml"
                Else
                    TConnection.Response_ContentType = "text/html"
                End If
                ' end hack
                SendHTTPSTRING(cUserConnection, TConnection, Overrideable)
                DI = Nothing
                FI = Nothing
                Overrideable = Nothing
                Exit Sub
            End If



            'see if we are serving a file or a directory
            If TConnection.Request_LocalIsDir = True Then
                Debug.WriteLine("Is Dir")
                If DI.Exists = False Then
                    'serve an error message
                    TConnection.Response_Number = ResponseCodes.HTTP_NOTFOUND
                    TConnection.Response_Text = "Error"
                    TConnection.Response_ContentType = "text/html"
                    SendHTTPResponse(cUserConnection, TConnection, Return404() & vbCrLf & TConnection.Request_Filename)
                    DI = Nothing
                    FI = Nothing
                    Exit Sub
                End If
            Else
                Debug.WriteLine("Is File")
                If ((FI.Exists = False) And (Overrideable = String.Empty)) Then
                    'serve an error message
                    TConnection.Response_Number = ResponseCodes.HTTP_NOTFOUND
                    TConnection.Response_Text = "Error"
                    TConnection.Response_ContentType = "text/html"
                    SendHTTPResponse(cUserConnection, TConnection, Return404() & vbCrLf & TConnection.Request_Filename)
                    DI = Nothing
                    FI = Nothing
                    Exit Sub
                End If
            End If


            If TConnection.Request_LocalIsDir = True Then
                'serve a directory
                '1 Check to see if index.html exists in the directory if so serve it instead
                '2 get the directory information as a stream
                '3 Send it to the socket

                If New FileInfo(TConnection.Request_LocalFilename & StartFile).Exists = True Then
                    TConnection.Response_Number = ResponseCodes.HTTP_OK
                    TConnection.Response_Text = "OK"
                    TConnection.Request_LocalFilename = TConnection.Request_LocalFilename & "index.html"
                    TConnection.Response_ContentType = GetMimeType(TConnection.Request_LocalFilename)
                    SendHTTPFILE(cUserConnection, TConnection)

                Else
                    TConnection.Response_Number = ResponseCodes.HTTP_OK
                    TConnection.Response_Text = "OK"
                    TConnection.Response_ContentType = "text/html"
                    SendHTTPDIR(cUserConnection, TConnection)
                    DI = Nothing
                    FI = Nothing
                    Exit Sub
                End If

                'serve a file
                '1 get the file as a stream
                '2 Get the Content Type from the registry
                '3 Send it to the socket
                TConnection.Response_Number = ResponseCodes.HTTP_OK
                TConnection.Response_Text = "OK"
                TConnection.Response_ContentType = GetMimeType(TConnection.Request_LocalFilename)
                SendHTTPFILE(cUserConnection, TConnection)
                DI = Nothing
                FI = Nothing
                Exit Sub

            Else

            End If



        Catch ex As Exception

            Try
                'serve an error message
                TConnection.Response_Number = ResponseCodes.HTTP_SERVERERROR
                TConnection.Response_Text = "Error"
                SendHTTPResponse(cUserConnection, TConnection, Return500(ex.Message))
                MsgBox(CStr("DEBUG" & ex.Message))
            Catch Ex2 As Exception
                MsgBox(CStr("DEBUG2" & Ex2.Message))
            Finally
                cUserConnection.client.Close()

            End Try
        End Try
    End Sub

    Public Function GetMimeType(ByVal sFile As String) As String
        'look for the mime type info in the registry
        Dim FI As New FileInfo(sFile)
        Dim RegClasses As RegistryKey = Registry.ClassesRoot
        Dim FileTypeKey As RegistryKey = RegClasses.OpenSubKey(FI.Extension)
        Dim sVal As String
        If FileTypeKey Is Nothing Then
            Return "text/html"
            RegClasses.Close()
            FileTypeKey.Close()
            Exit Function
        Else
            sVal = FileTypeKey.GetValue("Content Type")
            If sVal = "" Then
                Return "text/html"
                RegClasses.Close()
                FileTypeKey.Close()
                Exit Function
            Else
                Return sVal
                RegClasses.Close()
                FileTypeKey.Close()
                Exit Function
            End If
        End If
    End Function

    Public Function Return404() As String
        Dim sTMP As String = String.Empty
        sTMP = sTMP & "<HTML><HEAD><TITLE>404 File not found</TITLE></HEAD><br>" & vbCrLf
        sTMP = sTMP & "<BODY BGCOLOR=" & Chr(34) & "#FFFFFF" & Chr(34) & " Text=" & Chr(34) & "#000000" & Chr(34) & " LINK=" & Chr(34) & "#0000FF" & Chr(34) & " VLINK=" & Chr(34) & "#000080" & Chr(34) & " ALINK=" & Chr(34) & "#008000" & Chr(34) & "><br>" & vbCrLf
        sTMP = sTMP & "<b>404</b> File not found<br>" & vbCrLf
        sTMP = sTMP & "</BODY><br>" & vbCrLf
        sTMP = sTMP & "</HTML><br>" & vbCrLf
        Return404 = sTMP
    End Function

    Public Function Return500(ByVal sMessage As String) As String
        Dim sTMP As String = String.Empty
        sTMP = sTMP & "<HTML><HEAD><TITLE>500 Internal Server Error</TITLE></HEAD><br>" & vbCrLf
        sTMP = sTMP & "<BODY BGCOLOR=" & Chr(34) & "#FFFFFF" & Chr(34) & " Text=" & Chr(34) & "#000000" & Chr(34) & " LINK=" & Chr(34) & "#0000FF" & Chr(34) & " VLINK=" & Chr(34) & "#000080" & Chr(34) & " ALINK=" & Chr(34) & "#008000" & Chr(34) & "><br>" & vbCrLf
        sTMP = sTMP & "<b>500</b> Sorry - Internal Server Error<br>" & sMessage & vbCrLf
        sTMP = sTMP & "</BODY><br>" & vbCrLf
        sTMP = sTMP & "</HTML><br>" & vbCrLf
        Return500 = sTMP
    End Function

    Public Sub SendHTTPDIR(ByVal cUserConnection As UserConnection, ByRef TConnection As HTTPConnection)
        'HTTP/1.1 200 OK
        'Server: Microsoft-IIS/5.0
        'Content-Location: http://127.0.0.1/index.html
        'Date: Wed, 10 Dec 2003 19:10:25 GMT
        'Content-Type: text/html
        'Accept-Ranges: bytes
        'Last-Modified: Mon, 22 Sep 2003 22:36:56 GMT
        'Content-Length: 1957
        Dim sHeader As String = String.Empty
        Dim sLine As String = String.Empty
        'Dim sParse As String
        Dim sPath As String = String.Empty
        Dim NWStream As NetworkStream = cUserConnection.client.GetStream
        Dim DI As New DirectoryInfo(TConnection.Request_LocalFilename)
        Dim DIRINFO As DirectoryInfo
        Dim FILEINFO As FileInfo

        If TConnection.Response_Handled = True Then Exit Sub
        sLine = sLine & "<html><head><title>Listing For: " & TConnection.Request_Filename & "</title></head><body>" & vbCrLf
        sLine = sLine & "<h4>Listing For: " & TConnection.Request_Filename & "</h4><br>" & vbCrLf
        sLine = sLine & "<BR><B>Directories</B> <font size=" & Chr(34) & "1" & Chr(34) & ">(Total Directories: " & DI.GetDirectories.GetUpperBound(0) + 1 & ")</font><HR>" & vbCrLf
        For Each DIRINFO In DI.GetDirectories
            sPath = Replace(LCase(DIRINFO.FullName), LCase(RootDirectory), "")
            sPath = Replace(sPath, "\", "/")
            sPath = sPath & "/"
            sLine = sLine & "<a href=" & Chr(34) & sPath & Chr(34) & ">" & DIRINFO.Name & "</a><br>" & vbCrLf
        Next
        sLine = sLine & "<BR><B>Files</B> <font size=" & Chr(34) & "1" & Chr(34) & ">(Total Files: " & DI.GetFiles.GetUpperBound(0) + 1 & ")</font><HR>" & vbCrLf
        For Each FILEINFO In DI.GetFiles
            sPath = Replace(LCase(FILEINFO.FullName), LCase(RootDirectory), "")
            sPath = Replace(sPath, "\", "/")
            sLine = sLine & "<a href=" & Chr(34) & sPath & Chr(34) & ">" & FILEINFO.Name & "</a> <font size=" & Chr(34) & "1" & Chr(34) & ">(" & FILEINFO.Length & ")</font><br>" & vbCrLf
        Next
        sLine = sLine & "</body></html>"
        sHeader = sHeader & TConnection.Request_HTTPVersion & " " & TConnection.Response_Number & " " & TConnection.Response_Text & vbCrLf
        sHeader = sHeader & "Server: " & TConnection.Response_ServerType & vbCrLf
        sHeader = sHeader & "Date: " & Now & vbCrLf 'Format(Now(), "Long Time")
        sHeader = sHeader & "Content-Type: " & TConnection.Response_ContentType & vbCrLf
        sHeader = sHeader & "Accept-Ranges: bytes" & vbCrLf
        sHeader = sHeader & "Content-Length: " & sLine.Length & vbCrLf
        sHeader = sHeader & vbCrLf
        sHeader = sHeader & sLine

        Dim sendBytes As [Byte]() = Encoding.ASCII.GetBytes(sHeader)
        NWStream.Write(sendBytes, 0, sendBytes.Length)
        'close the connection
        If LCase(TConnection.Request_ConnectionType) <> "keep-alive" Then
            cUserConnection.client.Close()
        End If

    End Sub

    Public Sub SendHTTPSTRING(ByVal cUserConnection As UserConnection, ByRef TConnection As HTTPConnection, ByVal ServerString As String)
        'HTTP/1.1 200 OK
        'Server: Microsoft-IIS/5.0
        'Content-Location: http://127.0.0.1/index.html
        'Date: Wed, 10 Dec 2003 19:10:25 GMT
        'Content-Type: text/html
        'Accept-Ranges: bytes
        'Last-Modified: Mon, 22 Sep 2003 22:36:56 GMT
        'Content-Length: 1957
        Dim sHeader As String = String.Empty
        'Dim sParse As String
        Dim NWStream As NetworkStream = cUserConnection.client.GetStream

        If TConnection.Response_Handled = True Then Exit Sub


        sHeader = sHeader & TConnection.Request_HTTPVersion & " " & TConnection.Response_Number & " " & TConnection.Response_Text & vbCrLf
        sHeader = sHeader & "Server: " & TConnection.Response_ServerType & vbCrLf
        sHeader = sHeader & "Date: " & Now & vbCrLf 'Format(Now(), "Long Time")
        sHeader = sHeader & "Content-Type: " & TConnection.Response_ContentType & vbCrLf
        sHeader = sHeader & "Accept-Ranges: bytes" & vbCrLf
        sHeader = sHeader & "Content-Length: " & ServerString.Length & vbCrLf
        sHeader = sHeader & vbCrLf
        sHeader = sHeader & ServerString

        Dim sendBytes As [Byte]() = Encoding.ASCII.GetBytes(sHeader)
        NWStream.Write(sendBytes, 0, sendBytes.Length)
        'close the connection
        If LCase(TConnection.Request_ConnectionType) <> "keep-alive" Then
            cUserConnection.client.Close()
        End If

    End Sub

    Public Sub SendHTTPFILE(ByVal cUserConnection As UserConnection, ByRef TConnection As HTTPConnection)
        'HTTP/1.1 200 OK
        'Server: Microsoft-IIS/5.0
        'Content-Location: http://127.0.0.1/index.html
        'Date: Wed, 10 Dec 2003 19:10:25 GMT
        'Content-Type: text/html
        'Accept-Ranges: bytes
        'Last-Modified: Mon, 22 Sep 2003 22:36:56 GMT
        'Content-Length: 1957
        Dim sHeader As String = String.Empty
        Dim NWStream As NetworkStream = cUserConnection.client.GetStream
        Dim FI As New FileInfo(TConnection.Request_LocalFilename)
        Dim IPOS As Integer = 0
        Dim SendBUFFSize As Integer = cUserConnection.client.SendBufferSize

        If TConnection.Response_Handled = True Then Exit Sub
        Debug.WriteLine(TConnection.Response_ContentType)
        sHeader = sHeader & TConnection.Request_HTTPVersion & " " & TConnection.Response_Number & " " & TConnection.Response_Text & vbCrLf
        sHeader = sHeader & "Server: " & TConnection.Response_ServerType & vbCrLf
        sHeader = sHeader & "Date: " & Now & vbCrLf 'Format(Now(), "Long Time")
        sHeader = sHeader & "Content-Type: " & TConnection.Response_ContentType & vbCrLf
        sHeader = sHeader & "Accept-Ranges: bytes" & vbCrLf
        sHeader = sHeader & "Content-Length: " & FI.Length & vbCrLf
        sHeader = sHeader & vbCrLf

        Dim sendBytes As [Byte]() = Encoding.ASCII.GetBytes(sHeader)


        If sendBytes.Length > SendBUFFSize Then
            Do Until IPOS >= sendBytes.Length
                Debug.WriteLine(IPOS)
                NWStream.Write(sendBytes, IPOS, SendBUFFSize)
                IPOS = IPOS + SendBUFFSize
            Loop
        Else
            NWStream.Write(sendBytes, 0, sendBytes.Length)
        End If

        'NWStream.Write(sendBytes, 0, sendBytes.Length)
        cUserConnection.SendFile(TConnection.Request_LocalFilename)

        'close the connection
        If LCase(TConnection.Request_ConnectionType) <> "keep-alive" Then
            cUserConnection.client.Close()
        End If

    End Sub

    Public Sub SendHTTPResponse(ByVal cUserConnection As UserConnection, ByRef TConnection As HTTPConnection, ByVal sReponse As String)
        'HTTP/1.1 200 OK
        'Server: Microsoft-IIS/5.0
        'Content-Location: http://127.0.0.1/index.html
        'Date: Wed, 10 Dec 2003 19:10:25 GMT
        'Content-Type: text/html
        'Accept-Ranges: bytes
        'Last-Modified: Mon, 22 Sep 2003 22:36:56 GMT
        'Content-Length: 1957
        Dim sHeader As String = String.Empty
        Dim NWStream As NetworkStream = cUserConnection.client.GetStream
        Dim IPOS As Integer = 0
        Dim SendBUFFSize As Integer = cUserConnection.client.SendBufferSize

        sHeader = sHeader & TConnection.Request_HTTPVersion & " " & TConnection.Response_Number & " " & TConnection.Response_Text & vbCrLf
        sHeader = sHeader & "Server: " & TConnection.Response_ServerType & vbCrLf
        sHeader = sHeader & "Date: " & Now & vbCrLf 'Format(Now(), "Long Time")
        sHeader = sHeader & "Content-Type: " & TConnection.Response_ContentType & vbCrLf
        sHeader = sHeader & "Accept-Ranges: bytes" & vbCrLf
        sHeader = sHeader & "Content-Length: " & sReponse.Length & vbCrLf
        sHeader = sHeader & vbCrLf

        sHeader = sHeader & sReponse

        If TConnection.Response_Handled = True Then Exit Sub
        Dim sendBytes As [Byte]() = Encoding.ASCII.GetBytes(sHeader)
        If sendBytes.Length > SendBUFFSize Then
            Do Until IPOS >= sendBytes.Length
                Debug.WriteLine(IPOS)
                NWStream.Write(sendBytes, IPOS, SendBUFFSize)
                IPOS = IPOS + SendBUFFSize
            Loop
        Else
            NWStream.Write(sendBytes, 0, sendBytes.Length)
        End If
        NWStream.Flush()
        'close the connection
        If LCase(TConnection.Request_ConnectionType) <> "keep-alive" Then
            cUserConnection.client.Close()
        End If
    End Sub

    Private Sub ParseHTTPHeader(ByVal sData As String, ByRef TConnection As HTTPConnection)
        'GET /test/a%20picture.jpg HTTP/1.1
        'Accept: image/gif, image/x-xbitmap, image/jpeg, image/pjpeg, application/vnd.ms-powerpoint, application/vnd.ms-excel, application/msword, application/x-shockwave-flash, */*
        'Accept-Language: en-us
        'Accept-Encoding: gzip, deflate
        'User-Agent: Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; .NET CLR 1.0.3705; .NET CLR 1.1.4322)
        'Host: 127.0.0.1:81
        'Connection: Keep-Alive
        'Cookie: IDHTTPSESSIONID=RxQbcqGwptvxbZY
        'Referer: http://www.voidrealms.com
        Dim sLine As String
        Dim Ipos As Integer
        Dim sDelim As String
        Dim sMethod() As String
        Dim sFilename As String
        Dim sLines() As String
        Dim I As Integer
        'MsgBox(sData)
        sLines = Split(sData, vbCrLf)


        For I = sLines.GetLowerBound(0) To sLines.GetUpperBound(0)
            sLine = Trim(sLines(I))
            'MsgBox(sLine)
            'Debug.WriteLine(sLine)

            'get the Host
            sDelim = "ost: "
            Ipos = InStr(LCase(sLine), sDelim)
            If Ipos <> 0 Then
                TConnection.Request_Host = Trim(Mid(sLine, sDelim.Length, sLine.Length))
            End If

            'get the accept types
            sDelim = "ccept: "
            Ipos = InStr(LCase(sLine), sDelim)
            If Ipos <> 0 Then
                TConnection.Request_Accept = Trim(Mid(sLine, sDelim.Length, sLine.Length))
            End If

            'get the accept language
            sDelim = "ccept-language: "
            Ipos = InStr(LCase(sLine), sDelim)
            If Ipos <> 0 Then
                TConnection.Request_AcceptLanguage = Trim(Mid(sLine, sDelim.Length, sLine.Length))
            End If

            'get the accept encoding
            sDelim = "ccept-encoding: "
            Ipos = InStr(LCase(sLine), sDelim)
            If Ipos <> 0 Then
                TConnection.Request_Encoding = Trim(Mid(sLine, sDelim.Length, sLine.Length))
            End If

            'get the user agent
            sDelim = "ser-agent: "
            Ipos = InStr(LCase(sLine), sDelim)
            If Ipos <> 0 Then
                TConnection.Request_Useragent = Trim(Mid(sLine, sDelim.Length, sLine.Length))
            End If

            'get the Connection type
            sDelim = "onnection: "
            Ipos = InStr(LCase(sLine), sDelim)
            If Ipos <> 0 Then
                TConnection.Request_ConnectionType = Trim(Mid(sLine, sDelim.Length, sLine.Length))
            End If

            'get the Cookie
            sDelim = "ookie: "
            Ipos = InStr(LCase(sLine), sDelim)
            If Ipos <> 0 Then
                TConnection.Request_Cookie = Trim(Mid(sLine, sDelim.Length, sLine.Length))
            End If

            'get the Referer
            sDelim = "eferer: "
            Ipos = InStr(LCase(sLine), sDelim)
            If Ipos > 0 Then
                TConnection.Request_Referer = Trim(Mid(sLine, sDelim.Length, sLine.Length))
            End If

            'get the Method and Data
            sDelim = "GET "
            Ipos = InStr(sLine, sDelim)
            If Ipos <> 0 Then
                sMethod = Split(sLine, " ")

                TConnection.Request_Method = Trim(sMethod(0))
                TConnection.Request_Filename = Trim(Replace(sMethod(1), "%20", " ")) 'replace any encoding
                TConnection.Request_HTTPVersion = Trim(sMethod(2))
                If Mid(RootDirectory, Len(RootDirectory), Len(RootDirectory)) = "\" Then
                    RootDirectory = Mid(RootDirectory, 1, Len(RootDirectory) - 1)
                End If
                sFilename = RootDirectory & Replace(TConnection.Request_Filename, "/", "\")
                TConnection.Request_LocalFilename = sFilename
            End If

        Next I
        If Mid(TConnection.Request_LocalFilename, Len(TConnection.Request_LocalFilename), Len(TConnection.Request_LocalFilename)) = "\" Then
            TConnection.Request_LocalIsDir = True
        End If
        TConnection.Response_Number = ResponseCodes.HTTP_OK
        TConnection.Response_Text = "OK"
        TConnection.Response_ContentType = "text/html"
        TConnection.Response_ServerType = "Power-Sockets"
        TConnection.Response_Handled = False
    End Sub

    Private Function ParseHTTPHeader2(ByVal sData As String) As HTTPConnection ', ByRef TConnection As HTTPConnection)
        'Dim TConnection As HTTPConnection
        Dim TConnection = New HTTPConnection

        'GET /test/a%20picture.jpg HTTP/1.1
        'Accept: image/gif, image/x-xbitmap, image/jpeg, image/pjpeg, application/vnd.ms-powerpoint, application/vnd.ms-excel, application/msword, application/x-shockwave-flash, */*
        'Accept-Language: en-us
        'Accept-Encoding: gzip, deflate
        'User-Agent: Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; .NET CLR 1.0.3705; .NET CLR 1.1.4322)
        'Host: 127.0.0.1:81
        'Connection: Keep-Alive
        'Cookie: IDHTTPSESSIONID=RxQbcqGwptvxbZY
        'Referer: http://www.voidrealms.com
        Dim sLine As String
        Dim Ipos As Integer
        Dim sDelim As String
        Dim sMethod() As String
        Dim sFilename As String
        Dim sLines() As String
        Dim I As Integer
        'MsgBox(sData)
        sLines = Split(sData, vbCrLf)


        For I = sLines.GetLowerBound(0) To sLines.GetUpperBound(0)
            sLine = Trim(sLines(I))
            'MsgBox(sLine)
            'Debug.WriteLine(sLine)

            'get the Host
            sDelim = "host: "
            Ipos = InStr(LCase(sLine), sDelim)
            If Ipos <> 0 Then
                TConnection.Request_Host = Trim(Mid(sLine, sDelim.Length, sLine.Length))
            End If

            'get the accept types
            sDelim = "accept: "
            Ipos = InStr(LCase(sLine), sDelim)
            If Ipos <> 0 Then
                TConnection.Request_Accept = Trim(Mid(sLine, sDelim.Length, sLine.Length))
            End If

            'get the accept language
            sDelim = "accept-language: "
            Ipos = InStr(LCase(sLine), sDelim)
            If Ipos <> 0 Then
                TConnection.Request_AcceptLanguage = Trim(Mid(sLine, sDelim.Length, sLine.Length))
            End If

            'get the accept encoding
            sDelim = "accept-encoding: "
            Ipos = InStr(LCase(sLine), sDelim)
            If Ipos <> 0 Then
                TConnection.Request_Encoding = Trim(Mid(sLine, sDelim.Length, sLine.Length))
            End If

            'get the user agent
            sDelim = "user-agent: "
            Ipos = InStr(LCase(sLine), sDelim)
            If Ipos <> 0 Then
                TConnection.Request_Useragent = Trim(Mid(sLine, sDelim.Length, sLine.Length))
            End If

            'get the Connection type
            sDelim = "connection: "
            Ipos = InStr(LCase(sLine), sDelim)
            If Ipos <> 0 Then
                TConnection.Request_ConnectionType = Trim(Mid(sLine, sDelim.Length, sLine.Length))
            End If

            'get the Cookie
            sDelim = "cookie: "
            Ipos = InStr(LCase(sLine), sDelim)
            If Ipos <> 0 Then
                TConnection.Request_Cookie = Trim(Mid(sLine, sDelim.Length, sLine.Length))
            End If

            'get the Referer
            sDelim = "referer: "
            Ipos = InStr(LCase(sLine), sDelim)
            If Ipos > 0 Then
                TConnection.Request_Referer = Trim(Mid(sLine, sDelim.Length, sLine.Length))
            End If

            'get the Method and Data
            sDelim = "GET "
            Ipos = InStr(sLine, sDelim)
            If Ipos <> 0 Then
                sMethod = Split(sLine, " ")

                TConnection.Request_Method = Trim(sMethod(0))
                TConnection.Request_Filename = Trim(Replace(sMethod(1), "%20", " ")) 'replace any encoding
                TConnection.Request_HTTPVersion = Trim(sMethod(2))
                '  If Mid(RootDirectory, Len(RootDirectory), Len(RootDirectory)) = "\" Then
                '     RootDirectory = Mid(RootDirectory, 1, Len(RootDirectory) - 1)
                'End If
                sFilename = RootDirectory & Replace(TConnection.Request_Filename, "/", "\")
                TConnection.Request_LocalFilename = sFilename
            End If

        Next I
        If Mid(TConnection.Request_LocalFilename, Len(TConnection.Request_LocalFilename), Len(TConnection.Request_LocalFilename)) = "\" Then
            TConnection.Request_LocalIsDir = True
        End If
        TConnection.Response_Number = ResponseCodes.HTTP_OK
        TConnection.Response_Text = "OK"
        TConnection.Response_ContentType = "text/html"
        TConnection.Response_ServerType = "Power-Sockets"
        TConnection.Response_Handled = False


        Return TConnection

    End Function

    Private Sub cServer_StatusUpdate(ByVal sStatus As String) Handles cServer.StatusUpdate
        RaiseEvent StatusUpdate(sStatus)
    End Sub

    Public Sub StartServer()
        cServer.StartServer()
    End Sub

    Public Sub StopServer()
        cServer.StopServer()
    End Sub


    Public Sub New(Optional ByVal Port = 80)
        cServer.Port = CInt(Port)
    End Sub

    Protected Overrides Sub Finalize()
        On Error Resume Next
        cServer.StopServer()
        cServer = Nothing
        MyBase.Finalize()
    End Sub
End Class

'FTP Server uses the file transfer protocol to transfer files (Port 21 Default)
Public Class FTPServer
    Public Structure FTPClient
        Dim Username As String 'the clients username
        Dim Password As String 'the clients password
        Dim Authenticated As Boolean 'if the client has logged in
        Dim RootDirectory As String 'the starting directory for the client
        Dim CurrentDirectory As String 'the current directory the client is in
        Dim CurrentFile As String 'the current file the client is working with
        Dim LocalFile As String 'the local name of the current file
        Dim LocalFileOffset As Integer 'the starting position of the file
        Dim LocalDirectory As String 'the local name of the current directory
        Dim CurrentCommand As String 'the command the client last sent
        Dim CommandParams As String 'the parms the client sent with last comand
        Dim LastReponse As String 'the last response we sent the client
        Dim AllowAction As Boolean 'flag T/F to allow / deny the client action (reset per command)
        Dim Passive As Boolean 'T/F client is in passive mode
        Dim IP As String 'the IP of the client to connect to
        Dim Port As Integer 'the port of the client to connect to
        Dim FTPDataSocket_NORM As TcpClient()   'sock used to connect to client in normal mode
        Dim FTPDataSocket_PASV As TcpListener 'socket used to listen for client in passive mode
    End Structure

    Public Structure FTPResponseCodes
        Const msgDftBanner As String = "220 VB.Net FTP Server ready (Version 1.0)."
        Const msgTooMuchClients As String = "421 Too many users connected."
        Const msgCmdUnknown As String = "500 %s: command not understood."
        Const msgLoginFailed As String = "530 Login incorrect."
        Const msgNotLogged As String = "530 Please login with USER and PASS."
        Const msgNoUser As String = "503 Login with USER first."
        Const msgLogged As String = "230 User %s logged in."
        Const msgPassRequired As String = "331 Password required for %s."
        Const msgCWDSuccess As String = "250 CWD command successful. %s is current directory."
        Const msgCWDFailed As String = "501 CWD failed. %s"
        Const msgPWDSuccess As String = "257 %s is current directory."
        Const msgQuit As String = "221 Goodbye."
        Const msgPortSuccess As String = "200 Port command successful."
        Const msgPortFailed As String = "501 Invalid PORT command."
        Const msgStorDisabled As String = "500 Cannot STOR."
        Const msgStorSuccess As String = "150 Opening data connection for %s."
        Const msgStorFailed As String = "501 Cannot STOR. %s"
        Const msgStorAborted As String = "426 Connection closed %s."
        Const msgStorOk As String = "226 File received ok"
        Const msgStorError As String = "426 Connection closed transfer aborted. Error #%d"
        Const msgRetrDisabled As String = "500 Cannot RETR."
        Const msgRetrSuccess As String = "150 Opening data connection for %s."
        Const msgRetrFailed As String = "501 Cannot RETR. %s"
        Const msgRetrAborted As String = "426 Connection closed %s."
        Const msgRetrOk As String = "226 File sent ok"
        Const msgRetrError As String = "426 Connection closed transfer aborted. Error #%d"
        Const msgSystem As String = "215 UNIX Type: L8 VB.Net FTP Server"
        Const msgDirOpen As String = "150 Opening data connection for directory list."
        Const msgDirFailed As String = "451 Failed: %s."
        Const msgTypeOk As String = "200 Type set to %s."
        Const msgTypeFailed As String = "500 TYPE %s: command not understood."
        Const msgDeleNotExists As String = "550 %s: no such file or directory."
        Const msgDeleOk As String = "250 File %s deleted."
        Const msgDeleFailed As String = "450 File %s cant be deleted."
        Const msgDeleSyntax As String = "501 Syntax error in parameter."
        Const msgDeleDisabled As String = "500 Cannot DELE."
        Const msgRnfrNotExists As String = "550 %s: no such file or directory."
        Const msgRnfrSyntax As String = "501 Syntax error is parameter."
        Const msgRnfrOk As String = "350 File exists, ready for destination name."
        Const msgRntoNotExists As String = "550 %s: no such file or directory."
        Const msgRntoAlready As String = "553 %s: file already exists."
        Const msgRntoOk As String = "250 File %s renamed to %d."
        Const msgRntoFailed As String = "450 File %s cant be renamed."
        Const msgRntoSyntax As String = "501 Syntax error in parameter."
        Const msgMkdOk As String = "257 %s: directory created."
        Const msgMkdAlready As String = "550 %s: file or directory already exists."
        Const msgMkdFailed As String = "550 %s: cant create directory."
        Const msgMkdSyntax As String = "501 Syntax error in parameter."
        Const msgRmdOk As String = "250 %s: directory removed."
        Const msgRmdNotExists As String = "550 %s: no such directory."
        Const msgRmdFailed As String = "550 %s: cant remove directory."
        Const msgRmdSyntax As String = "501 Syntax error in parameter."
        Const msgNoopOk As String = "200 Ok. Parameter was %s."
        Const msgAborOk As String = "225 ABOR command successful."
        Const msgPasvLocal As String = "227 Entering Passive Mode (127,0,0,1,%d,%d)."
        Const msgPasvRemote As String = "227 Entering Passive Mode (%d,%d,%d,%d,%d,%d)."
        Const msgPasvExcept As String = "500 PASV exception: %s."
        Const msgSizeOk As String = "213 %d"
        Const msgSizeFailed As String = "550 Command failed: %s."
        Const msgSizeSyntax As String = "501 Syntax error in parameter."
        Const msgRestOk As String = "350 REST supported. Ready to resume at byte offset %d."
        Const msgRestZero As String = "501 Required byte offset parameter bad or missing."
        Const msgRestFailed As String = "501 Syntax error in parameter: %s."
        Const msgAppeFailed As String = "550 APPE failed."
        Const msgAppeSuccess As String = "150 Opening data connection for %s (append)."
        Const msgAppeDisabled As String = "500 Cannot APPE."
        Const msgAppeAborted As String = "426 Connection closed %s."
        Const msgAppeOk As String = "226 File received ok"
        Const msgAppeError As String = "426 Connection closed transfer aborted. Error #%d"
        Const msgAppeReady As String = "150 APPE supported.  Ready to append file %s at offset %d."
        Const msgStruOk As String = "200 Ok. STRU parameter %s ignored."
        Const msgSendComplete As String = "226 Transfer complete"
        Const msgSendFailed As String = "501 Transfer Failed"
        Const msgSendDirStart As String = "150 Opening ASCII mode data connection for %s."
        Dim iInstance As Integer
    End Structure

    Public WithEvents cServer As New BaseServer()
    Public Event StatusUpdate(ByVal sStatus As String)
    Public Event DataReceived(ByVal sender As UserConnection, ByVal Data As String)
    Public Event ClientConnected(ByVal sender As UserConnection)
    Public Event ClientDisConnected(ByVal sender As UserConnection)
    Public Event ClientLogin(ByVal sender As UserConnection, ByRef TFTPClient As FTPClient) 'after client sends USER and PASS
    Public Event ClientLogout(ByVal sender As UserConnection, ByRef TFTPClient As FTPClient) 'when client quits
    Public Event ClientAction(ByVal sender As UserConnection, ByRef TFTPClient As FTPClient) 'called on any action
    Public Event Client_CWD(ByVal sender As UserConnection, ByRef TFTPClient As FTPClient) 'change current directory
    Public Event Client_CDUP(ByVal sender As UserConnection, ByRef TFTPClient As FTPClient) 'go up one directory
    Public Event Client_MKD(ByVal sender As UserConnection, ByRef TFTPClient As FTPClient) 'make a directory
    Public Event Client_NLST(ByVal sender As UserConnection, ByRef TFTPClient As FTPClient) 'short dir list
    Public Event Client_REST(ByVal sender As UserConnection, ByRef TFTPClient As FTPClient) 'restart the file position
    Public Event Client_DELE(ByVal sender As UserConnection, ByRef TFTPClient As FTPClient) 'client wants to delete a file
    Public Event Client_RETR(ByVal sender As UserConnection, ByRef TFTPClient As FTPClient) 'download a file
    Public Event Client_STOR(ByVal sender As UserConnection, ByRef TFTPClient As FTPClient) 'upload a file
    Public Event Client_RMD(ByVal sender As UserConnection, ByRef TFTPClient As FTPClient) 'delete a directory
    Public Event Client_RNFR(ByVal sender As UserConnection, ByRef TFTPClient As FTPClient) 'rename file from
    Public Event Client_RNTO(ByVal sender As UserConnection, ByRef TFTPClient As FTPClient) 'rename file to
    Public Event Client_PORT(ByVal sender As UserConnection, ByRef TFTPClient As FTPClient) 'client sends us the connection info
    Public Event Client_PASV(ByVal sender As UserConnection, ByRef TFTPClient As FTPClient) 'client enters a passive state
    Public Event Client_LIST(ByVal sender As UserConnection, ByRef TFTPClient As FTPClient) 'client wants info on a file or dir
    Public Event Client_HELP(ByVal sender As UserConnection, ByRef TFTPClient As FTPClient) 'client wants a list of allowed commands

    Private Sub cServer_ClientConnected(ByVal sender As UserConnection) Handles cServer.ClientConnected
        RaiseEvent ClientConnected(sender)
        Dim aFTPSTRUCT As FTPClient
        Dim sFTPResponse As FTPResponseCodes
        aFTPSTRUCT.AllowAction = True
        aFTPSTRUCT.CurrentCommand = "/"
        sender.sExtraValues = aFTPSTRUCT
        SendFTPResponse(sender, sFTPResponse.msgDftBanner)

    End Sub

    Private Sub cServer_ClientDisConnected(ByVal sender As UserConnection) Handles cServer.ClientDisConnected
        RaiseEvent ClientDisConnected(sender)
    End Sub

    Private Sub cServer_DataReceived(ByVal sender As UserConnection, ByVal Data As String) Handles cServer.DataReceived
        'Parse the FTP Command
        Dim aFTPSTRUCT As FTPClient = sender.sExtraValues
        Dim aFTPResponse As FTPResponseCodes
        Dim sFTPResponse As String
        Dim Ipos As Integer
        Dim sFTPData As String = Replace(Data, vbCrLf, "")
        Dim sFTPCommand As String
        Dim sFTPParam As String
        Dim sP1 As Integer
        Dim sP2 As Integer
        Dim sIPInfo() As String
        Dim sTMP As String

        aFTPSTRUCT.AllowAction = True

        RaiseEvent DataReceived(sender, Data)

        Ipos = InStr(LCase(sFTPData), " ")
        If Ipos <> 0 Then
            sFTPCommand = Trim(Mid(sFTPData, 1, Ipos))
            sFTPParam = Trim(Mid(sFTPData, Ipos + 1, sFTPData.Length))
        Else
            sFTPCommand = sFTPData
            sFTPParam = ""
        End If
        aFTPSTRUCT.CurrentCommand = sFTPCommand
        aFTPSTRUCT.CommandParams = sFTPParam

        RaiseEvent ClientAction(sender, aFTPSTRUCT)
        sender.sExtraValues = aFTPSTRUCT
        Debug.WriteLine("IN from Client: " & "|" & aFTPSTRUCT.CurrentCommand & "=" & aFTPSTRUCT.CommandParams & "|")
        'process the request and send back a response
        If aFTPSTRUCT.Username = "" And UCase(aFTPSTRUCT.CurrentCommand) <> "USER" Then
            sFTPResponse = aFTPResponse.msgNotLogged
        Else
            Select Case UCase(aFTPSTRUCT.CurrentCommand)

                Case Is = "USER" 'they are attempting to login
                    aFTPSTRUCT.Username = sFTPParam
                    sFTPResponse = Replace(aFTPResponse.msgPassRequired, "%s", aFTPSTRUCT.Username)

                Case Is = "PASS" 'they are attempting to login
                    aFTPSTRUCT.Password = sFTPParam
                    RaiseEvent ClientLogin(sender, aFTPSTRUCT)

                    If Mid(aFTPSTRUCT.RootDirectory, Len(aFTPSTRUCT.RootDirectory), Len(aFTPSTRUCT.RootDirectory)) = "\" Then
                        aFTPSTRUCT.RootDirectory = Mid(aFTPSTRUCT.RootDirectory, 1, Len(aFTPSTRUCT.RootDirectory) - 1)
                    End If
                    aFTPSTRUCT.LocalDirectory = aFTPSTRUCT.RootDirectory

                    'see if the login passed
                    If aFTPSTRUCT.Authenticated = True Then
                        sFTPResponse = Replace(aFTPResponse.msgLogged, "%s", aFTPSTRUCT.Username)
                    Else
                        sFTPResponse = aFTPResponse.msgLoginFailed
                    End If

                Case Is = "TYPE"
                    sFTPResponse = Replace(aFTPResponse.msgTypeOk, "%s", aFTPSTRUCT.CommandParams)

                Case Is = "REST" 'they are seeing if we support broken downloads
                    sender.sExtraValues = aFTPSTRUCT
                    RaiseEvent Client_REST(sender, aFTPSTRUCT)
                    If aFTPSTRUCT.AllowAction = True Then
                        If aFTPSTRUCT.CommandParams = "" Then
                            sFTPResponse = Replace(aFTPResponse.msgRestFailed, "%s", aFTPSTRUCT.CommandParams)
                        Else
                            If IsNumeric(aFTPSTRUCT.CommandParams) = False Then
                                sFTPResponse = Replace(aFTPResponse.msgRestZero, "%s", aFTPSTRUCT.CommandParams)
                            Else
                                aFTPSTRUCT.LocalFileOffset = CInt(aFTPSTRUCT.CommandParams)
                                sFTPResponse = Replace(aFTPResponse.msgRestOk, "%d", aFTPSTRUCT.CommandParams)
                            End If
                        End If
                    Else
                        sFTPResponse = Replace(aFTPResponse.msgRestFailed, "%s", "User not allowed")
                    End If


                Case Is = "NOOP" 'no operation used to keep connection alive
                    sFTPResponse = aFTPResponse.msgNoopOk

                Case Is = "PWD" 'they want to know what directory they are in
                    sFTPResponse = Replace(aFTPResponse.msgPWDSuccess, "%s", Chr(34) & aFTPSTRUCT.CurrentDirectory & Chr(34))

                Case Is = "CWD" 'they want to change directoryies

                    sender.sExtraValues = aFTPSTRUCT
                    RaiseEvent Client_CWD(sender, aFTPSTRUCT)
                    If aFTPSTRUCT.AllowAction = True Then
                        sFTPResponse = ChangeCurrentDir(aFTPSTRUCT, aFTPSTRUCT.CommandParams)
                        Debug.WriteLine("SET pwd test:" & aFTPSTRUCT.CurrentDirectory)
                    Else
                        sFTPResponse = Replace(aFTPResponse.msgCWDFailed, "%s", "User not allowed")
                    End If

                Case Is = "PORT" 'they are telling us where / port to connect to them
                    'this is a tricky one because they are really sending us two variables
                    'ip address and port number = a1,a2,a3,a4,p1,p2
                    '127,0,0,1,4,51
                    'IP address a1.a2.a3.a4, port p1*256+p2 (4*256+51=1075)
                    'Ip= 127.0.0.1 Port= 1075
                    sender.sExtraValues = aFTPSTRUCT
                    RaiseEvent Client_PORT(sender, aFTPSTRUCT)

                    If aFTPSTRUCT.AllowAction = True Then
                        aFTPSTRUCT.Passive = False
                        sIPInfo = Split(aFTPSTRUCT.CommandParams, ",")
                        If sIPInfo.GetUpperBound(0) = 5 Then
                            aFTPSTRUCT.IP = ""
                            aFTPSTRUCT.IP = aFTPSTRUCT.IP & sIPInfo(0) & "."
                            aFTPSTRUCT.IP = aFTPSTRUCT.IP & sIPInfo(1) & "."
                            aFTPSTRUCT.IP = aFTPSTRUCT.IP & sIPInfo(2) & "."
                            aFTPSTRUCT.IP = aFTPSTRUCT.IP & sIPInfo(3)
                            sP1 = CInt(sIPInfo(4))
                            sP2 = CInt(sIPInfo(5))
                            aFTPSTRUCT.Port = sP1 * 256 + sP2
                            sFTPResponse = aFTPResponse.msgPortSuccess
                            Debug.WriteLine(aFTPSTRUCT.IP & ":" & aFTPSTRUCT.Port)
                        Else
                            sFTPResponse = aFTPResponse.msgPortFailed
                            Debug.WriteLine(aFTPSTRUCT.IP & ":" & aFTPSTRUCT.Port)
                        End If
                    Else
                        sFTPResponse = Replace(aFTPResponse.msgPortFailed, "%s", "User not allowed")
                    End If

                Case Is = "CDUP"
                    sender.sExtraValues = aFTPSTRUCT
                    RaiseEvent Client_CDUP(sender, aFTPSTRUCT)
                    If aFTPSTRUCT.AllowAction = True Then
                        Debug.WriteLine("CDUP From:" & aFTPSTRUCT.LocalDirectory)
                        aFTPSTRUCT.LocalDirectory = GetParentDir(aFTPSTRUCT.LocalDirectory)
                        Debug.WriteLine("CDUP TO:" & aFTPSTRUCT.LocalDirectory)

                        Debug.WriteLine("CDUP Remote From:" & aFTPSTRUCT.CurrentDirectory)
                        aFTPSTRUCT.CurrentDirectory = GetRemoteFromLocal(aFTPSTRUCT.LocalDirectory, aFTPSTRUCT.RootDirectory)
                        Debug.WriteLine("CDUP Remote TO:" & aFTPSTRUCT.CurrentDirectory)

                        sFTPResponse = Replace(aFTPResponse.msgCWDSuccess, "%s", aFTPSTRUCT.CurrentDirectory)

                    Else
                        sFTPResponse = Replace(aFTPResponse.msgCWDFailed, "%s", "User not allowed")
                    End If


                Case Is = "LIST" 'they want a detailed listing of the current directory
                    'we have to create a socket,connect to them, and send the information to them
                    'unless they are in passive mode, then
                    'we have to open a listening socket and wait for them, then send data
                    sender.sExtraValues = aFTPSTRUCT
                    RaiseEvent Client_LIST(sender, aFTPSTRUCT)
                    If aFTPSTRUCT.AllowAction = True Then
                        sTMP = BuildDirpacket(aFTPSTRUCT.LocalDirectory, False)
                        sFTPResponse = aFTPResponse.msgDirOpen
                        If aFTPSTRUCT.Passive = False Then
                            'they are in normal mode - connect to them and send
                            aFTPSTRUCT.LastReponse = sFTPResponse
                            sender.sExtraValues = aFTPSTRUCT
                            sFTPResponse = Replace(aFTPResponse.msgSendDirStart, "%s", aFTPSTRUCT.CurrentDirectory)
                            SendFTPResponse(sender, sFTPResponse) 'send the response NOW
                            sFTPResponse = ConnectToAndSendData(sender, sTMP)
                            SendFTPResponse(sender, sFTPResponse) 'send the response NOW
                            sFTPResponse = ""
                        Else
                            'they are in passive mode - wait for them to connect to us
                            MsgBox("passive not supported atm")
                        End If
                    Else
                        sFTPResponse = Replace(aFTPResponse.msgDirFailed, "%s", "User not allowed")
                    End If



                Case Is = "NLST" 'they want only file names for the current directory
                    'we have to create a socket,connect to them, and send the information to them
                    'unless they are in passive mode, then
                    'we have to open a listening socket and wait for them, then send data
                    sender.sExtraValues = aFTPSTRUCT
                    RaiseEvent Client_NLST(sender, aFTPSTRUCT)
                    If aFTPSTRUCT.AllowAction = True Then
                        sTMP = BuildDirpacket(aFTPSTRUCT.LocalDirectory, True)
                        sFTPResponse = aFTPResponse.msgDirOpen
                        If aFTPSTRUCT.Passive = False Then
                            'they are in normal mode - connect to them and send
                            aFTPSTRUCT.LastReponse = sFTPResponse
                            sender.sExtraValues = aFTPSTRUCT
                            sFTPResponse = Replace(aFTPResponse.msgSendDirStart, "%s", aFTPSTRUCT.CurrentDirectory)
                            SendFTPResponse(sender, sFTPResponse) 'send the response NOW
                            sFTPResponse = ConnectToAndSendData(sender, sTMP)
                            SendFTPResponse(sender, sFTPResponse) 'send the response NOW
                            sFTPResponse = ""
                        Else
                            'they are in passive mode - wait for them to connect to us
                            MsgBox("passive not supported atm")
                        End If
                    Else
                        sFTPResponse = Replace(aFTPResponse.msgDirFailed, "%s", "User not allowed")
                    End If


                Case Is = "SYST" 'they want to know what type of system this is
                    sFTPResponse = aFTPResponse.msgSystem 'lie to them and say we are using a UNIX

                Case Is = "DELE" 'they want to delete a file
                    sender.sExtraValues = aFTPSTRUCT
                    RaiseEvent Client_DELE(sender, aFTPSTRUCT)
                    If aFTPSTRUCT.AllowAction = True Then
                        sFTPResponse = DeleteFTPFile(aFTPSTRUCT.LocalDirectory, aFTPSTRUCT.CommandParams)
                    Else
                        sFTPResponse = Replace(aFTPResponse.msgDeleDisabled, "%s", "User not allowed")
                    End If


                Case Is = "MKD" 'they want to make a directory
                    sender.sExtraValues = aFTPSTRUCT
                    RaiseEvent Client_MKD(sender, aFTPSTRUCT)
                    If aFTPSTRUCT.AllowAction = True Then
                        sFTPResponse = MakeFTPDirectory(aFTPSTRUCT.LocalDirectory, aFTPSTRUCT.CommandParams)
                    Else
                        sFTPResponse = Replace(aFTPResponse.msgMkdFailed, "%s", "User not allowed")
                    End If


                Case Is = "RMD" 'delete a directory
                    sender.sExtraValues = aFTPSTRUCT
                    RaiseEvent Client_RMD(sender, aFTPSTRUCT)
                    If aFTPSTRUCT.AllowAction = True Then
                        sFTPResponse = DeleteFTPDirectory(aFTPSTRUCT.LocalDirectory, aFTPSTRUCT.CommandParams)
                    Else
                        sFTPResponse = Replace(aFTPResponse.msgRmdFailed, "%s", "User not allowed")
                    End If


                Case Is = "RNFR" 'rename file from command
                    sender.sExtraValues = aFTPSTRUCT
                    RaiseEvent Client_RNFR(sender, aFTPSTRUCT)
                    If aFTPSTRUCT.AllowAction = True Then
                        sFTPResponse = RNFRFTPFile(aFTPSTRUCT, aFTPSTRUCT.LocalDirectory, aFTPSTRUCT.CommandParams)
                    Else
                        sFTPResponse = Replace(aFTPResponse.msgRnfrNotExists, "%s", "User not allowed")
                    End If


                Case Is = "RNTO" 'rename file to command
                    sender.sExtraValues = aFTPSTRUCT
                    RaiseEvent Client_RNTO(sender, aFTPSTRUCT)
                    If aFTPSTRUCT.AllowAction = True Then
                        sFTPResponse = RNTOFTPFile(aFTPSTRUCT.LocalDirectory, aFTPSTRUCT.LocalFile, aFTPSTRUCT.CommandParams)
                    Else
                        sFTPResponse = Replace(aFTPResponse.msgRntoFailed, "%s", aFTPSTRUCT.LocalFile)
                    End If


                Case Is = "STOR" ' they want to upload a file to us
                    sender.sExtraValues = aFTPSTRUCT
                    RaiseEvent Client_STOR(sender, aFTPSTRUCT)
                    If aFTPSTRUCT.AllowAction = True Then
                        sFTPResponse = PrepairFileUpload(aFTPSTRUCT, aFTPSTRUCT.LocalDirectory, aFTPSTRUCT.CommandParams)
                        If aFTPSTRUCT.Passive = False Then
                            If InStr(sFTPResponse, "150") <> 0 Then
                                'they are in normal mode - connect to them and send
                                aFTPSTRUCT.LastReponse = sFTPResponse
                                sender.sExtraValues = aFTPSTRUCT
                                SendFTPResponse(sender, sFTPResponse) 'send the response NOW

                                sFTPResponse = ConnectToGetFile(sender)

                                SendFTPResponse(sender, sFTPResponse) 'send the response NOW
                                sFTPResponse = ""
                            End If
                        Else
                            'they are in passive mode - wait for them to connect to us
                            MsgBox("passive not supported atm")
                        End If
                    Else
                        sFTPResponse = Replace(aFTPResponse.msgStorDisabled, "%s", "User not allowed")
                    End If

                Case Is = "RETR" 'they want to download a file from us
                    sender.sExtraValues = aFTPSTRUCT
                    RaiseEvent Client_RETR(sender, aFTPSTRUCT)
                    If aFTPSTRUCT.AllowAction = True Then
                        sFTPResponse = PrepairFileDownload(aFTPSTRUCT, aFTPSTRUCT.LocalDirectory, aFTPSTRUCT.CommandParams)
                        If aFTPSTRUCT.Passive = False Then
                            If InStr(sFTPResponse, "150") <> 0 Then
                                'they are in normal mode - connect to them and send
                                aFTPSTRUCT.LastReponse = sFTPResponse
                                sender.sExtraValues = aFTPSTRUCT
                                SendFTPResponse(sender, sFTPResponse) 'send the response NOW

                                sFTPResponse = ConnectToSendFile(sender)

                                SendFTPResponse(sender, sFTPResponse) 'send the response NOW
                                sFTPResponse = ""
                            End If
                        Else
                            'they are in passive mode - wait for them to connect to us
                            MsgBox("passive not supported atm")
                        End If
                    Else
                        sFTPResponse = Replace(aFTPResponse.msgRetrFailed, "%s", "User not allowed")
                    End If


                Case Is = "PASV" 'they want passive mode, we must create a socket they can connect to and send them info on it
                    'this is not implimented at the moment, so send an error message
                    sender.sExtraValues = aFTPSTRUCT
                    RaiseEvent Client_PASV(sender, aFTPSTRUCT)
                    If aFTPSTRUCT.AllowAction = True Then
                        sFTPResponse = Replace(aFTPResponse.msgPasvExcept, "%s", "Not Implemented")
                    Else
                        sFTPResponse = Replace(aFTPResponse.msgPasvExcept, "%s", "User not allowed")
                    End If


                Case Is = "QUIT" 'they want to end this session

                    RaiseEvent ClientLogout(sender, aFTPSTRUCT)
                    sFTPResponse = aFTPResponse.msgQuit
                    SendFTPResponse(sender, sFTPResponse) 'send the response NOW
                    sender.CloseClientConenction()
                    Exit Sub

                Case Is = "HELP" 'they want a list of commands
                    sender.sExtraValues = aFTPSTRUCT
                    RaiseEvent Client_HELP(sender, aFTPSTRUCT)
                    If aFTPSTRUCT.AllowAction = True Then
                        sFTPResponse = "No Help Available"
                    Else
                        sFTPResponse = "500 User not allowed"
                        sFTPResponse = "500 User not allowed"
                    End If


                Case Else
                    sFTPResponse = Replace(aFTPResponse.msgCmdUnknown, "%s", aFTPSTRUCT.CurrentCommand)
            End Select
        End If

        aFTPSTRUCT.LastReponse = sFTPResponse
        sender.sExtraValues = aFTPSTRUCT
        'sender.SendData(aFTPSTRUCT.Username)
        SendFTPResponse(sender, sFTPResponse)
    End Sub

    Private Function PrepairFileDownload(ByRef aFTPSTRUCT As FTPClient, ByVal sParent As String, ByVal sFilename As String) As String
        Dim aFTPResponse As FTPResponseCodes
        Dim FI As New FileInfo(sParent & "\" & sFilename)
        Dim sTMP As String
        Try
            If FI.Exists = True Then
                sTMP = FI.Name & "(" & FI.Length & ")"
                PrepairFileDownload = Replace(aFTPResponse.msgRetrSuccess, "%s", sTMP)
                aFTPSTRUCT.LocalFile = sFilename
            Else
                aFTPSTRUCT.LocalFile = ""
                PrepairFileDownload = Replace(aFTPResponse.msgRetrFailed, "%s", sFilename)
            End If

        Catch ex As Exception
            PrepairFileDownload = Replace(aFTPResponse.msgRetrFailed, "%s", sFilename)
        End Try
    End Function

    Private Function PrepairFileUpload(ByRef aFTPSTRUCT As FTPClient, ByVal sParent As String, ByVal sFilename As String) As String
        Dim aFTPResponse As FTPResponseCodes
        Dim FI As New FileInfo(sParent & "\" & sFilename)
        Dim sTMP As String
        Try
            If FI.Exists = True Then
                sTMP = FI.Name & "(" & FI.Length & ")"
                PrepairFileUpload = Replace(aFTPResponse.msgStorFailed, "%s", sTMP)
                aFTPSTRUCT.LocalFile = ""
            Else
                PrepairFileUpload = Replace(aFTPResponse.msgStorSuccess, "%s", sFilename)
                aFTPSTRUCT.LocalFile = sFilename
            End If

        Catch ex As Exception
            PrepairFileUpload = Replace(aFTPResponse.msgStorError, "%d", ex.Message)

        End Try
    End Function

    Public Function ConnectToGetFile(ByRef cUserConnection As UserConnection) As String
        'connect to the remote user and send them information on a data socket
        Dim aFTPResponse As FTPResponseCodes
        Dim aFTPSTRUCT As FTPClient = cUserConnection.sExtraValues
        Try

            Dim sFilename As String = aFTPSTRUCT.LocalDirectory & "\" & aFTPSTRUCT.LocalFile
            Dim FI As New FileInfo(sFilename)
            If FI.Exists = True Then
                ConnectToGetFile = Replace(aFTPResponse.msgStorFailed, "%s", sFilename)
                Exit Function
            End If

            Dim client As New TcpClient()
            client.Connect(aFTPSTRUCT.IP, aFTPSTRUCT.Port)
            Dim NWStream As NetworkStream = client.GetStream
            Dim bytesToRead(client.ReceiveBufferSize) As Byte
            Dim numBytesRead As Integer '= NWStream.Read(bytesToRead, 0, CInt(client.ReceiveBufferSize))
            Dim BUFFER_SIZE As Integer = client.ReceiveBufferSize
            Dim FileSTR As New FileStream(sFilename, FileMode.CreateNew, FileAccess.Write)

            Do
                numBytesRead = 0
                numBytesRead = NWStream.Read(bytesToRead, 0, BUFFER_SIZE)
                FileSTR.Write(bytesToRead, 0, numBytesRead)
                Debug.WriteLine("Reading: " & numBytesRead)
                'The NWStream.DataAvailable always returned false in-between packets so double check by using "And numBytesRead = 0"
            Loop Until NWStream.DataAvailable = False And numBytesRead = 0

            FileSTR.Close()
            NWStream.Close()
            client.Close()

            ConnectToGetFile = aFTPResponse.msgStorOk
        Catch ex As Exception

            ConnectToGetFile = Replace(aFTPResponse.msgStorError, "%d", ex.Message)

        End Try
    End Function

    Public Function ConnectToSendFile(ByRef cUserConnection As UserConnection) As String
        'connect to the remote user and send them information on a data socket
        Dim aFTPResponse As FTPResponseCodes
        Dim aFTPSTRUCT As FTPClient = cUserConnection.sExtraValues
        Try
            Dim client As New TcpClient()
            client.Connect(aFTPSTRUCT.IP, aFTPSTRUCT.Port)
            Dim NWStream As NetworkStream = client.GetStream
            Dim bytesToSend(client.SendBufferSize) As Byte
            Dim sFilename As String = aFTPSTRUCT.LocalDirectory & "\" & aFTPSTRUCT.LocalFile
            Dim FI As New FileInfo(sFilename)
            Dim FileSTR As New FileStream(sFilename, FileMode.Open, FileAccess.Read)
            Dim FileReader As New BinaryReader(FileSTR)
            Dim numBytesRead As Integer
            Dim Ipos As Integer
            Do Until Ipos >= FI.Length
                numBytesRead = FileSTR.Read(bytesToSend, 0, bytesToSend.Length)
                NWStream.Write(bytesToSend, 0, numBytesRead)
                Ipos = Ipos + numBytesRead
                NWStream.Flush()
            Loop
            NWStream.Flush()
            FileSTR.Close()
            FileReader.Close()
            NWStream.Close()
            client.Close()
            ConnectToSendFile = aFTPResponse.msgRetrOk
        Catch ex As Exception
            ConnectToSendFile = Replace(aFTPResponse.msgRetrError, "%d", ex.Message)
        End Try
    End Function

    Private Function RNTOFTPFile(ByVal sParent As String, ByVal sOLDFilename As String, ByVal sNEWFilename As String) As String
        Dim aFTPResponse As FTPResponseCodes
        Dim FI As New FileInfo(sParent & "\" & sOLDFilename)
        Dim FINew As New FileInfo(sParent & "\" & sNEWFilename)
        Dim sTMP As String

        Try
            If FI.Exists = True Then
                If FINew.Exists = False Then
                    Rename(sParent & "\" & sOLDFilename, sParent & "\" & sNEWFilename)
                    sTMP = Replace(aFTPResponse.msgRntoOk, "%s", sOLDFilename)
                    RNTOFTPFile = Replace(sTMP, "%d", sNEWFilename)
                Else
                    RNTOFTPFile = Replace(aFTPResponse.msgRntoAlready, "%s", sNEWFilename)
                End If

            Else
                RNTOFTPFile = Replace(aFTPResponse.msgRntoNotExists, "%s", sOLDFilename)
            End If

        Catch ex As Exception
            RNTOFTPFile = Replace(aFTPResponse.msgRntoFailed, "%s", sOLDFilename)
        End Try
    End Function

    Private Function RNFRFTPFile(ByRef aFTPSTRUCT As FTPClient, ByVal sParent As String, ByVal sFilename As String) As String
        Dim aFTPResponse As FTPResponseCodes
        Dim FI As New FileInfo(sParent & "\" & sFilename)
        Try
            If FI.Exists = True Then
                RNFRFTPFile = aFTPResponse.msgRnfrOk
                aFTPSTRUCT.LocalFile = sFilename
            Else
                aFTPSTRUCT.LocalFile = ""
                RNFRFTPFile = Replace(aFTPResponse.msgRnfrNotExists, "%s", sFilename)
            End If

        Catch ex As Exception
            RNFRFTPFile = Replace(aFTPResponse.msgRnfrSyntax, "%s", sFilename)
        End Try
    End Function

    Private Function DeleteFTPFile(ByVal sParent As String, ByVal sFilename As String) As String
        Dim aFTPResponse As FTPResponseCodes
        Dim FI As New FileInfo(sParent & "\" & sFilename)
        Try
            If FI.Exists = True Then
                FI.Delete()
                DeleteFTPFile = Replace(aFTPResponse.msgDeleOk, "%s", sFilename)
            Else
                DeleteFTPFile = Replace(aFTPResponse.msgDeleNotExists, "%s", sFilename)
            End If

        Catch ex As Exception
            DeleteFTPFile = Replace(aFTPResponse.msgDeleFailed, "%s", sFilename)
        End Try
    End Function

    Private Function DeleteFTPDirectory(ByVal sParent As String, ByVal sDir As String) As String
        Dim aFTPResponse As FTPServer.FTPResponseCodes
        Dim DI As New DirectoryInfo(sParent & "\" & sDir)
        Try

            If DI.Exists = True Then
                DI.Delete()
                DeleteFTPDirectory = Replace(aFTPResponse.msgRmdOk, "%s", sDir)
            Else
                DeleteFTPDirectory = Replace(aFTPResponse.msgRmdNotExists, "%s", sDir)
            End If

        Catch ex As Exception
            DeleteFTPDirectory = Replace(aFTPResponse.msgRmdFailed, "%s", sDir)
        End Try
    End Function

    Private Function MakeFTPDirectory(ByVal sParent As String, ByVal sDir As String) As String
        Dim aFTPResponse As FTPResponseCodes
        Dim DI As New DirectoryInfo(sParent & "\" & sDir)
        Try
            If DI.Exists = False Then
                DI.Create()
                MakeFTPDirectory = Replace(aFTPResponse.msgMkdOk, "%s", sDir)
            Else
                MakeFTPDirectory = Replace(aFTPResponse.msgMkdAlready, "%s", sDir)
            End If
        Catch ex As Exception
            MakeFTPDirectory = Replace(aFTPResponse.msgMkdFailed, "%s", sDir)
        End Try
    End Function

    Private Function ChangeCurrentDir(ByRef aFTPSTRUCT As FTPClient, ByRef sDirectory As String) As String
        'find the dir they are looking for
        Dim aFTPResponse As FTPResponseCodes
        Dim sTMP As String
        Dim DI As DirectoryInfo
        Dim DIRINFO As DirectoryInfo
        Try
            Debug.WriteLine("Checking CWD:" & sDirectory)
            If InStr(sDirectory, "\") = 0 Then
                'Going to a child dir of the current
                DI = New DirectoryInfo(aFTPSTRUCT.LocalDirectory & "\" & sDirectory)
                If DI.Exists = True Then
                    Debug.WriteLine("CWD Exists:" & aFTPSTRUCT.LocalDirectory & "\" & sDirectory)
                    aFTPSTRUCT.LocalDirectory = aFTPSTRUCT.LocalDirectory & "\" & sDirectory
                    If aFTPSTRUCT.CurrentDirectory <> "\" Then
                        aFTPSTRUCT.CurrentDirectory = aFTPSTRUCT.CurrentDirectory & "\" & sDirectory
                    Else
                        aFTPSTRUCT.CurrentDirectory = "\" & sDirectory
                    End If
                    Debug.WriteLine("SET CWD:" & aFTPSTRUCT.CurrentDirectory)

                    ChangeCurrentDir = Replace(aFTPResponse.msgCWDSuccess, "%s", Chr(34) & aFTPSTRUCT.CurrentDirectory & Chr(34))
                Else
                    Debug.WriteLine("CWD NOT Exists:" & aFTPSTRUCT.LocalDirectory & "\" & sDirectory)
                    ChangeCurrentDir = Replace(aFTPResponse.msgCWDFailed, "%s", sDirectory)
                End If
            Else
                'Explicitly naming a directory
                Debug.WriteLine("CWD NAME Exists?:" & sDirectory)
                DI = New DirectoryInfo(aFTPSTRUCT.RootDirectory & "\" & sDirectory)
                If DI.Exists = True Then
                    Debug.WriteLine("CWD Exists:" & aFTPSTRUCT.RootDirectory & sDirectory)
                    aFTPSTRUCT.LocalDirectory = aFTPSTRUCT.RootDirectory & sDirectory
                    aFTPSTRUCT.CurrentDirectory = sDirectory

                    Debug.WriteLine("SET CWD:" & aFTPSTRUCT.CurrentDirectory)

                    ChangeCurrentDir = Replace(aFTPResponse.msgCWDSuccess, "%s", Chr(34) & aFTPSTRUCT.CurrentDirectory & Chr(34))
                Else
                    Debug.WriteLine("CWD NOT Exists:" & aFTPSTRUCT.LocalDirectory & "\" & sDirectory)
                    ChangeCurrentDir = Replace(aFTPResponse.msgCWDFailed, "%s", sDirectory)
                End If

            End If




        Catch ex As Exception
            ChangeCurrentDir = Replace(aFTPResponse.msgCWDFailed, "%s", sDirectory)
        End Try
    End Function

    Private Function GetParentDir(ByVal sDirectory As String) As String
        Dim DI As New DirectoryInfo(sDirectory)
        Dim DIRINFO As DirectoryInfo
        DIRINFO = DI.Parent
        GetParentDir = DIRINFO.FullName
    End Function

    Private Function GetRemoteFromLocal(ByVal sLocal As String, ByVal sRoot As String) As String
        Dim sTMP As String

        'sTMP = Replace(sLocal, sRoot, "") 'this did not help if the case changed
        sTMP = Mid(sLocal, sRoot.Length + 1, sLocal.Length)

        If Mid(sTMP, 1, 1) <> "\" Then
            sTMP = "\" & sTMP
        End If

        GetRemoteFromLocal = sTMP
    End Function

    Private Function FormatLocalDirectory(ByVal sLocal As String, ByVal sRemote As String) As String
        Dim sTMP As String = sLocal
        If Mid(sTMP, Len(sTMP), Len(sTMP)) = "\" Then
            sTMP = Mid(sTMP, 1, Len(sTMP) - 1)
        End If
        sTMP = sTMP & sRemote
        sTMP = Replace(sTMP, "/", "\")
        FormatLocalDirectory = sTMP
    End Function

    Public Sub SendFTPResponse(ByVal cUserConnection As UserConnection, ByVal sResponse As String)
        If sResponse = "" Then Exit Sub
        Debug.WriteLine("Sent to Client: " & sResponse)
        cUserConnection.SendData(sResponse & vbCrLf)
    End Sub

    Public Function ConnectToAndSendData(ByRef cUserConnection As UserConnection, ByRef sData As String) As String
        'connect to the remote user and send them information on a data socket
        Dim aFTPResponse As FTPResponseCodes
        Dim aFTPSTRUCT As FTPClient = cUserConnection.sExtraValues
        Try
            Debug.WriteLine("connecting to: " & aFTPSTRUCT.IP & ":" & aFTPSTRUCT.Port)
            Dim client As New TcpClient()
            client.Connect(aFTPSTRUCT.IP, aFTPSTRUCT.Port)
            'Dim writer As New IO.StreamWriter(client.GetStream)
            'client.Connect(aFTPSTRUCT.IP, aFTPSTRUCT.Port)
            Debug.WriteLine("sending to: " & aFTPSTRUCT.IP & ":" & aFTPSTRUCT.Port)
            'once connected send the data

            Dim NWStream As NetworkStream = client.GetStream
            Dim bytesToSend As Byte() = Encoding.ASCII.GetBytes(sData)
            Debug.WriteLine("DATA OUT=" & sData)
            NWStream.Write(bytesToSend, 0, bytesToSend.Length)
            Debug.WriteLine("LEN OUT=" & bytesToSend.Length)
            'writer.Write(sData)
            ' Make sure all data is sent now.
            NWStream.Flush()
            NWStream.Close()
            client.Close()
            ConnectToAndSendData = aFTPResponse.msgSendComplete
        Catch ex As Exception
            ConnectToAndSendData = aFTPResponse.msgSendFailed

        End Try
    End Function

    Public Function BuildDirpacket(ByVal sDirectory As String, ByVal ShortDir As Boolean) As String
        'ShortDirs are filenames only
        'long dirs require a special format
        '09-11-03  05:25PM       <DIR>          ftp
        '12-10-03  03:53PM       <DIR>          html
        '09-22-03  05:36PM                 8203 about.html

        Dim DI As New DirectoryInfo(sDirectory)
        Dim DIRINFO As DirectoryInfo
        Dim FILEINFO As FileInfo
        Dim sTMP As String = String.Empty
        Dim sDate As String = String.Empty
        Dim sTime As String = String.Empty
        Debug.WriteLine("Building DIR: " & sDirectory)
        If ShortDir = True Then
            For Each FILEINFO In DI.GetFiles
                sTMP = sTMP & FILEINFO.Name & vbCrLf
            Next
        Else
            For Each DIRINFO In DI.GetDirectories
                sDate = Format(DIRINFO.LastWriteTime, "MM-dd-yy")
                sTime = Format(DIRINFO.LastWriteTime, "hh:mmtt")
                sTMP = sTMP & sDate & "  " & sTime & "  <DIR>          " & DIRINFO.Name & vbCrLf
            Next
            For Each FILEINFO In DI.GetFiles
                sDate = Format(FILEINFO.LastWriteTime, "MM-dd-yy")
                sTime = Format(FILEINFO.LastWriteTime, "hh:mmtt")
                sTMP = sTMP & sDate & "  " & sTime & "                 " & FILEINFO.Length & " " & FILEINFO.Name & vbCrLf
            Next
        End If

        If sTMP = "" Then sTMP = " " & vbCrLf
        BuildDirpacket = sTMP
    End Function

    Private Sub cServer_StatusUpdate(ByVal sStatus As String) Handles cServer.StatusUpdate
        RaiseEvent StatusUpdate(sStatus)
    End Sub

    Public Sub StartServer()
        cServer.StartServer()
    End Sub

    Public Sub StopServer()
        cServer.StopServer()
    End Sub

    Public Sub New()
        cServer.Port = 21
    End Sub

    Protected Overrides Sub Finalize()
        On Error Resume Next
        cServer.StopServer()
        cServer = Nothing
        MyBase.Finalize()
    End Sub
End Class